/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketToggleArmorFeature(EquipmentSlot slot, byte featureIndex, boolean state) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("toggle_armor_feature");

    public static PacketToggleArmorFeature fromNetwork(FriendlyByteBuf buffer) {
        return new PacketToggleArmorFeature((EquipmentSlot)buffer.readEnum(EquipmentSlot.class), buffer.readByte(), buffer.readBoolean());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.slot);
        buf.writeByte(this.featureIndex);
        buf.writeBoolean(this.state);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketToggleArmorFeature message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            EquipmentSlot slot = message.slot();
            byte featureIndex = message.featureIndex();
            boolean state = message.state();
            if (ctx.flow().isClientbound()) {
                ClientUtils.setArmorUpgradeEnabled(slot, featureIndex, state);
            } else if (featureIndex >= 0 && featureIndex < ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot).size() && (PneumaticArmorItem.isPneumaticArmorPiece(player, slot) || slot == EquipmentSlot.HEAD && featureIndex == 0)) {
                CommonArmorHandler.getHandlerForPlayer(player).setUpgradeEnabled(slot, featureIndex, state);
            }
        }));
    }
}

