/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketToggleArmorFeatureBulk(List<FeatureSetting> features) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("toggle_armor_feature_bulk");

    public static PacketToggleArmorFeatureBulk fromNetwork(FriendlyByteBuf buffer) {
        return new PacketToggleArmorFeatureBulk(buffer.readList(FeatureSetting::fromNetwork));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeCollection(this.features, (b, feature) -> feature.toBytes((FriendlyByteBuf)b));
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketToggleArmorFeatureBulk message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            message.features().forEach(f -> {
                if (f.featureIndex >= 0 && f.featureIndex < ArmorUpgradeRegistry.getInstance().getHandlersForSlot(f.slot).size() && PneumaticArmorItem.isPneumaticArmorPiece(player, f.slot)) {
                    handler.setUpgradeEnabled(f.slot, f.featureIndex, f.state);
                }
            });
        }));
    }

    public record FeatureSetting(EquipmentSlot slot, byte featureIndex, boolean state) {
        static FeatureSetting fromNetwork(FriendlyByteBuf buffer) {
            return new FeatureSetting((EquipmentSlot)buffer.readEnum(EquipmentSlot.class), buffer.readByte(), buffer.readBoolean());
        }

        void toBytes(FriendlyByteBuf buffer) {
            buffer.writeEnum((Enum)this.slot);
            buffer.writeByte(this.featureIndex);
            buffer.writeBoolean(this.state);
        }
    }
}

