/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.network.TubeModulePacket;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.AirGrateModule;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record PacketUpdateAirGrateModule(TubeModulePacket.ModuleLocator locator, String entityFilter) implements TubeModulePacket<AirGrateModule>
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("update_air_grate");

    public static PacketUpdateAirGrateModule create(AbstractTubeModule module, String entityFilter) {
        return new PacketUpdateAirGrateModule(TubeModulePacket.ModuleLocator.forModule(module), entityFilter);
    }

    public static PacketUpdateAirGrateModule fromNetwork(FriendlyByteBuf buffer) {
        return new PacketUpdateAirGrateModule(TubeModulePacket.ModuleLocator.fromNetwork(buffer), buffer.readUtf());
    }

    public void write(FriendlyByteBuf buffer) {
        this.locator.write(buffer);
        buffer.writeUtf(this.entityFilter);
    }

    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void onModuleUpdate(AirGrateModule module, Player player) {
        if (module.isUpgraded()) {
            try {
                module.setEntityFilter(new EntityFilter(this.entityFilter));
            }
            catch (IllegalArgumentException e) {
                Log.warning("ignoring invalid entity filter {} ({})", this.entityFilter, e.getMessage());
            }
        }
    }
}

