/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketUpdateArmorColors(int[][] cols, int eyepiece) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("update_armor_colors");

    public static PacketUpdateArmorColors create() {
        int n;
        int[][] cols = new int[4][2];
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            ItemStack stack = ClientUtils.getClientPlayer().getItemBySlot(slot);
            Item item = stack.getItem();
            if (!(item instanceof PneumaticArmorItem)) continue;
            PneumaticArmorItem p = (PneumaticArmorItem)item;
            cols[slot.getIndex()][0] = p.getColor(stack);
            cols[slot.getIndex()][1] = p.getSecondaryColor(stack);
        }
        ItemStack stack = ClientUtils.getClientPlayer().getItemBySlot(EquipmentSlot.HEAD);
        Item item = stack.getItem();
        if (item instanceof PneumaticArmorItem) {
            PneumaticArmorItem p = (PneumaticArmorItem)item;
            n = p.getEyepieceColor(stack);
        } else {
            n = 0;
        }
        int eyepiece = n;
        return new PacketUpdateArmorColors(cols, eyepiece);
    }

    public static PacketUpdateArmorColors fromNetwork(FriendlyByteBuf buffer) {
        int[][] cols = new int[4][2];
        for (int i = 0; i < cols.length; ++i) {
            cols[i][0] = buffer.readInt();
            cols[i][1] = buffer.readInt();
        }
        return new PacketUpdateArmorColors(cols, buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        for (int[] col : this.cols) {
            buffer.writeInt(col[0]);
            buffer.writeInt(col[1]);
        }
        buffer.writeInt(this.eyepiece);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketUpdateArmorColors message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                ItemStack stack = player.getItemBySlot(slot);
                Item patt3366$temp = stack.getItem();
                if (!(patt3366$temp instanceof PneumaticArmorItem)) continue;
                PneumaticArmorItem p = (PneumaticArmorItem)patt3366$temp;
                p.setColor(stack, message.cols()[slot.getIndex()][0]);
                p.setSecondaryColor(stack, message.cols()[slot.getIndex()][1]);
            }
            ItemStack stack = player.getItemBySlot(EquipmentSlot.HEAD);
            Item patt3696$temp = stack.getItem();
            if (patt3696$temp instanceof PneumaticArmorItem) {
                PneumaticArmorItem p = (PneumaticArmorItem)patt3696$temp;
                p.setEyepieceColor(stack, message.eyepiece());
            }
        }));
    }
}

