/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketUpdateArmorExtraData(EquipmentSlot slot, ResourceLocation upgradeID, CompoundTag data) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("update_armor_extradata");
    private static final List<Map<String, Integer>> VALID_KEYS = new ArrayList<Map<String, Integer>>();

    private static void addKey(EquipmentSlot slot, String key, int nbtType) {
        VALID_KEYS.get(slot.getIndex()).put(key, nbtType);
    }

    public static PacketUpdateArmorExtraData fromNetwork(FriendlyByteBuf buffer) {
        return new PacketUpdateArmorExtraData((EquipmentSlot)buffer.readEnum(EquipmentSlot.class), buffer.readResourceLocation(), buffer.readNbt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.slot);
        buf.writeResourceLocation(this.upgradeID);
        buf.writeNbt((Tag)this.data);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketUpdateArmorExtraData message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            ItemStack stack = player.getItemBySlot(message.slot());
            if (stack.getItem() instanceof PneumaticArmorItem) {
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
                NBTUtils.initNBTTagCompound(stack);
                for (String key : message.data().getAllKeys()) {
                    Tag dataTag = message.data().get(key);
                    if (!PacketUpdateArmorExtraData.isKeyOKForSlot(key, message.slot(), Objects.requireNonNull(dataTag).getId())) continue;
                    Objects.requireNonNull(stack.getTag()).put(key, dataTag);
                    IArmorUpgradeHandler<?> upgradeHandler = ArmorUpgradeRegistry.getInstance().getUpgradeEntry(message.upgradeID());
                    if (upgradeHandler == null) continue;
                    upgradeHandler.onDataFieldUpdated(handler, key, dataTag);
                }
            }
        }));
    }

    private static boolean isKeyOKForSlot(String key, EquipmentSlot slot, int nbtType) {
        return VALID_KEYS.get(slot.getIndex()).get(key) == nbtType;
    }

    static {
        Arrays.stream(ArmorUpgradeRegistry.ARMOR_SLOTS).map(slot -> new HashMap()).forEach(VALID_KEYS::add);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.HEAD, "entityFilter", 8);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.HEAD, "CoordTracker", 10);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.LEGS, "speedBoost", 3);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.LEGS, "jumpBoost", 3);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.FEET, "JetBootsBuilderMode", 1);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.FEET, "JetBootsPower", 3);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.FEET, "JetBootsStabilizers", 1);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.FEET, "Hover", 1);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.FEET, "SmartHover", 1);
    }
}

