/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.network.DronePacket;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record PacketUpdateDebuggingDrone(DronePacket.DroneTarget droneTarget) implements DronePacket
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("update_debugging_drone");

    public static PacketUpdateDebuggingDrone create(IDroneBase drone) {
        return new PacketUpdateDebuggingDrone(drone == null ? DronePacket.DroneTarget.none() : drone.getPacketTarget());
    }

    public static PacketUpdateDebuggingDrone fromNetwork(FriendlyByteBuf buf) {
        return new PacketUpdateDebuggingDrone(DronePacket.DroneTarget.fromNetwork(buf));
    }

    public void write(FriendlyByteBuf buf) {
        this.droneTarget.toNetwork(buf);
    }

    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(Player player, IDroneBase droneBase) {
        CommonArmorHandler handler;
        if (player instanceof ServerPlayer && (handler = CommonArmorHandler.getHandlerForPlayer(player)).upgradeUsable(CommonUpgradeHandlers.droneDebugHandler, false)) {
            ItemStack stack = player.getItemBySlot(EquipmentSlot.HEAD);
            if (droneBase == null) {
                NBTUtils.removeTag(stack, "debuggingDrone");
                NBTUtils.removeTag(stack, "debuggingPC");
            } else {
                droneBase.storeTrackerData(stack);
                droneBase.getDebugger().trackAsDebugged((ServerPlayer)player);
            }
        }
    }
}

