/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.registry.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketUpdateGPSAreaTool(CompoundTag areaWidgetData, InteractionHand hand) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("update_gps_area_tool");

    public PacketUpdateGPSAreaTool(FriendlyByteBuf buffer) {
        this(buffer.readNbt(), (InteractionHand)buffer.readEnum(InteractionHand.class));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeNbt((Tag)this.areaWidgetData);
        buffer.writeEnum((Enum)InteractionHand.MAIN_HAND);
    }

    public static void handle(PacketUpdateGPSAreaTool message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            ItemStack stack = player.getItemInHand(message.hand);
            if (stack.getItem() == ModItems.GPS_AREA_TOOL.get()) {
                stack.setTag(message.areaWidgetData);
            }
        }));
    }

    public ResourceLocation id() {
        return ID;
    }
}

