/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.SyncedField;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketUpdateGui(int syncId, Object value, byte type) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("update_gui");

    public static PacketUpdateGui create(int syncId, SyncedField<?> syncField) {
        return new PacketUpdateGui(syncId, syncField.getValue(), SyncedField.getType(syncField));
    }

    public static PacketUpdateGui fromNetwork(FriendlyByteBuf buf) {
        int syncId = buf.readVarInt();
        byte type = buf.readByte();
        Object value = SyncedField.fromBytes(buf, type);
        return new PacketUpdateGui(syncId, value, type);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.syncId);
        buf.writeByte(this.type);
        SyncedField.toBytes(buf, this.value, this.type);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketUpdateGui message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ClientUtils.syncViaOpenContainerScreen(message.syncId(), message.value()));
    }
}

