/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Objects;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.config.subconfig.MicromissileDefaults;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketUpdateMicromissileSettings(float topSpeed, float accel, float damage, PointXY point, String entityFilter, MicromissilesItem.FireMode fireMode, boolean saveDefault, InteractionHand hand) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("packetupdatemicromissilesettings");

    public static PacketUpdateMicromissileSettings fromNetwork(FriendlyByteBuf buffer) {
        return new PacketUpdateMicromissileSettings(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), new PointXY(buffer.readInt(), buffer.readInt()), buffer.readUtf(), (MicromissilesItem.FireMode)buffer.readEnum(MicromissilesItem.FireMode.class), buffer.readBoolean(), (InteractionHand)buffer.readEnum(InteractionHand.class));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeFloat(this.topSpeed);
        buf.writeFloat(this.accel);
        buf.writeFloat(this.damage);
        buf.writeInt(this.point.x());
        buf.writeInt(this.point.y());
        buf.writeUtf(this.entityFilter);
        buf.writeEnum((Enum)this.fireMode);
        buf.writeBoolean(this.saveDefault);
        buf.writeEnum((Enum)this.hand);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketUpdateMicromissileSettings message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            ItemStack stack = player.getItemInHand(message.hand());
            if (!stack.isEmpty()) {
                message.applySettings((Player)player, stack);
            } else {
                Log.warning("Received PacketUpdateMicromissileSettings but player does not hold a Micromissile? " + player.getName(), new Object[0]);
            }
        }));
    }

    private void applySettings(Player player, ItemStack stack) {
        if (!stack.hasTag()) {
            stack.setTag(new CompoundTag());
        }
        CompoundTag tag = Objects.requireNonNull(stack.getTag());
        tag.putFloat("turnSpeed", this.accel);
        tag.putFloat("topSpeed", this.topSpeed);
        tag.putFloat("damage", this.damage);
        tag.putInt("px", this.point.x());
        tag.putInt("py", this.point.y());
        tag.putString("filter", this.entityFilter);
        tag.putString("fireMode", this.fireMode.toString());
        if (this.saveDefault) {
            MicromissileDefaults.INSTANCE.setDefaults(player, new MicromissileDefaults.Entry(this.topSpeed, this.accel, this.damage, this.point, this.entityFilter, this.fireMode));
            MicromissileDefaults.INSTANCE.tryWriteToFile();
            player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.CHIRP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

