/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketUpdatePressureBlock(BlockPos pos, Direction handlerDir, Direction leakDir, int currentAir) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("update_pressure_block");

    public static PacketUpdatePressureBlock fromNetwork(FriendlyByteBuf buffer) {
        return new PacketUpdatePressureBlock(buffer.readBlockPos(), (Direction)buffer.readNullable(buf -> (Direction)buf.readEnum(Direction.class)), (Direction)buffer.readNullable(buf -> (Direction)buf.readEnum(Direction.class)), buffer.readInt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeNullable((Object)this.handlerDir, FriendlyByteBuf::writeEnum);
        buf.writeNullable((Object)this.leakDir, FriendlyByteBuf::writeEnum);
        buf.writeInt(this.currentAir);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketUpdatePressureBlock message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            BlockEntity blockEntity = ClientUtils.getBlockEntity(message.pos());
            if (blockEntity != null) {
                PNCCapabilities.getAirHandler(blockEntity, message.handlerDir()).ifPresent(handler -> {
                    handler.setSideLeaking(message.leakDir());
                    handler.addAir(message.currentAir() - handler.getAir());
                    if (message.handlerDir() != null && blockEntity instanceof AbstractAirHandlingBlockEntity) {
                        AbstractAirHandlingBlockEntity aah = (AbstractAirHandlingBlockEntity)blockEntity;
                        aah.initializeHullAirHandlerClient(message.handlerDir(), (IAirHandlerMachine)handler);
                    }
                });
            }
        });
    }
}

