/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.network.TubeModulePacket;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record PacketUpdatePressureModule(TubeModulePacket.ModuleLocator locator, float lower, float higher, boolean advanced) implements TubeModulePacket<AbstractTubeModule>
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("update_pressure_module");

    public static PacketUpdatePressureModule create(AbstractTubeModule module) {
        return new PacketUpdatePressureModule(TubeModulePacket.ModuleLocator.forModule(module), module.lowerBound, module.higherBound, module.advancedConfig);
    }

    public static PacketUpdatePressureModule fromNetwork(FriendlyByteBuf buffer) {
        return new PacketUpdatePressureModule(TubeModulePacket.ModuleLocator.fromNetwork(buffer), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean());
    }

    public void write(FriendlyByteBuf buffer) {
        this.locator.write(buffer);
        buffer.writeFloat(this.lower);
        buffer.writeFloat(this.higher);
        buffer.writeBoolean(this.advanced);
    }

    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void onModuleUpdate(AbstractTubeModule module, Player player) {
        module.lowerBound = this.lower;
        module.higherBound = this.higher;
        module.advancedConfig = this.advanced;
    }
}

