/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.RemoteItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketUpdateRemoteLayout(CompoundTag layout, InteractionHand hand) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("update_remote_layout");

    public static PacketUpdateRemoteLayout fromNetwork(FriendlyByteBuf buffer) {
        return new PacketUpdateRemoteLayout(buffer.readNbt(), (InteractionHand)buffer.readEnum(InteractionHand.class));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.layout);
        buf.writeEnum((Enum)this.hand);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketUpdateRemoteLayout message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            ItemStack remote = player.getItemInHand(message.hand());
            if (remote.getItem() instanceof RemoteItem) {
                CompoundTag tag = remote.getTag();
                if (tag == null) {
                    tag = new CompoundTag();
                    remote.setTag(tag);
                }
                tag.put("actionWidgets", (Tag)message.layout().getList("actionWidgets", 10));
            }
        }));
    }
}

