/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketUpdateSearchItem(Item item) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("search_item");

    public static PacketUpdateSearchItem fromNetwork(FriendlyByteBuf buffer) {
        return new PacketUpdateSearchItem((Item)buffer.readById((IdMap)BuiltInRegistries.ITEM));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeId((IdMap)BuiltInRegistries.ITEM, (Object)this.item);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketUpdateSearchItem message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            ItemStack helmetStack;
            CommonArmorHandler handler;
            if (message.item() != null && message.item() != Items.AIR && (handler = CommonArmorHandler.getHandlerForPlayer(player)).upgradeUsable(CommonUpgradeHandlers.searchHandler, true) && (helmetStack = player.getItemBySlot(EquipmentSlot.HEAD)).getItem() instanceof PneumaticArmorItem) {
                PneumaticArmorItem.setSearchedItem(helmetStack, message.item());
            }
        }));
    }
}

