/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.block.entity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketUpdateTextfield(int textFieldID, String text) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("update_textfield");

    public static PacketUpdateTextfield create(IGUITextFieldSensitive sensitive, int id) {
        return new PacketUpdateTextfield(id, sensitive.getText(id));
    }

    public static PacketUpdateTextfield fromNetwork(FriendlyByteBuf buffer) {
        return new PacketUpdateTextfield(buffer.readVarInt(), buffer.readUtf());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.textFieldID);
        buffer.writeUtf(this.text);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketUpdateTextfield message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> PacketUtil.getBlockEntity(player, BlockEntity.class).ifPresent(te -> {
            if (te instanceof IGUITextFieldSensitive) {
                IGUITextFieldSensitive sensitive = (IGUITextFieldSensitive)te;
                sensitive.setText(message.textFieldID(), message.text());
            }
        })));
    }
}

