/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;

public class PacketUtil {
    public static void writeGlobalPos(FriendlyByteBuf buf, GlobalPos gPos) {
        buf.writeResourceLocation(gPos.dimension().location());
        buf.writeBlockPos(gPos.pos());
    }

    public static GlobalPos readGlobalPos(FriendlyByteBuf buf) {
        ResourceKey worldKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buf.readResourceLocation());
        BlockPos pos = buf.readBlockPos();
        return GlobalPos.of((ResourceKey)worldKey, (BlockPos)pos);
    }

    public static void writeVec3f(Vector3f vec, FriendlyByteBuf buf) {
        buf.writeFloat(vec.x);
        buf.writeFloat(vec.y);
        buf.writeFloat(vec.z);
    }

    public static Vector3f readVec3f(FriendlyByteBuf buf) {
        return new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    @Nonnull
    public static <T extends BlockEntity> Optional<T> getBlockEntity(Player player, BlockPos pos, Class<T> cls) {
        if (player == null || player.level().isClientSide) {
            return ClientUtils.getOptionalClientLevel().flatMap(level -> PneumaticCraftUtils.getTileEntityAt((BlockGetter)level, pos, cls));
        }
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof AbstractPneumaticCraftMenu) {
            AbstractPneumaticCraftMenu pncMenu = (AbstractPneumaticCraftMenu)abstractContainerMenu;
            Object te = pncMenu.blockEntity;
            if (te != null && cls.isAssignableFrom(te.getClass()) && (pos == null || te.getBlockPos().equals((Object)pos))) {
                return Optional.of(te);
            }
        }
        return Optional.empty();
    }

    @Nonnull
    public static <T extends BlockEntity> Optional<T> getBlockEntity(Player player, Class<T> cls) {
        if (player.level().isClientSide) {
            throw new RuntimeException("don't call this method client side!");
        }
        return PacketUtil.getBlockEntity(player, null, cls);
    }

    public static void writeOptionalBlockState(FriendlyByteBuf buf, Optional<BlockState> state) {
        buf.writeOptional(state, (b, state1) -> b.writeNbt((Tag)NbtUtils.writeBlockState((BlockState)state1)));
    }

    public static Optional<BlockState> readOptionalBlockState(FriendlyByteBuf buf) {
        return buf.readOptional(b -> {
            CompoundTag tag = b.readNbt();
            return NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)Objects.requireNonNull(tag));
        });
    }
}

