/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public interface TubeModulePacket<T extends AbstractTubeModule>
extends CustomPacketPayload {
    public static <T extends AbstractTubeModule> void handle(TubeModulePacket<T> message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> PneumaticCraftUtils.getTileEntityAt((BlockGetter)player.getCommandSenderWorld(), message.locator().pos(), PressureTubeBlockEntity.class).ifPresent(te -> {
            try {
                AbstractTubeModule tm = te.getModule(message.locator().side());
                if (tm != null && PneumaticCraftUtils.canPlayerReach(player, te.getBlockPos())) {
                    message.onModuleUpdate((Object)tm, (Player)player);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        })));
    }

    public ModuleLocator locator();

    public void onModuleUpdate(T var1, Player var2);

    public record ModuleLocator(BlockPos pos, Direction side) {
        public static ModuleLocator forModule(AbstractTubeModule module) {
            return new ModuleLocator(module.getTube().getBlockPos(), module.getDirection());
        }

        public static ModuleLocator fromNetwork(FriendlyByteBuf buf) {
            return new ModuleLocator(buf.readBlockPos(), (Direction)buf.readEnum(Direction.class));
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeBlockPos(this.pos);
            buf.writeEnum((Enum)this.side);
        }
    }
}

