/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.BuiltinArmorUpgrades;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.registry.ModCriterionTriggers;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class JetBootsHandler
extends BaseArmorUpgradeHandler<JetBootsLocalState> {
    public static final int BUILDER_MODE_LEVEL = 3;
    public static final int STABILIZERS_LEVEL = 4;

    @Override
    public ResourceLocation getID() {
        return BuiltinArmorUpgrades.JET_BOOTS;
    }

    @Override
    public PNCUpgrade[] getRequiredUpgrades() {
        return new PNCUpgrade[]{ModUpgrades.JET_BOOTS.get()};
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.FEET;
    }

    @Override
    public Supplier<JetBootsLocalState> extensionData() {
        return JetBootsLocalState::new;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        if (commonArmorHandler.isOnCooldown(EquipmentSlot.FEET)) {
            return;
        }
        int jetbootsCount = commonArmorHandler.getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.JET_BOOTS.get());
        if (jetbootsCount == 0) {
            return;
        }
        int jetbootsAirUsage = 0;
        Player player = commonArmorHandler.getPlayer();
        JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
        JetBootsLocalState jbLocal = commonArmorHandler.getExtensionData(this);
        if (commonArmorHandler.hasMinPressure(EquipmentSlot.FEET)) {
            if (jbState.isActive()) {
                if (jbState.isBuilderMode() && jetbootsCount >= 3) {
                    this.setYMotion((Entity)player, player.isShiftKeyDown() ? 0.0 : 0.15 + 0.15 * (double)(jetbootsCount - 3));
                    jetbootsAirUsage = (int)((float)((Integer)ConfigHelper.common().armor.jetBootsAirUsage.get() * jetbootsCount) / 2.5f);
                } else {
                    Vec3 lookVec = player.getLookAngle().scale(0.3 * (double)jetbootsCount);
                    jbLocal.updateAccel(lookVec);
                    lookVec = jbLocal.getEffectiveMotion(lookVec, player.isFallFlying());
                    player.setDeltaMovement(lookVec.x, player.onGround() ? 0.0 : lookVec.y, lookVec.z);
                    jetbootsAirUsage = jbLocal.calcAirUsage(jetbootsCount);
                }
                if (player.isInWater()) {
                    jetbootsAirUsage *= 4;
                }
                jbLocal.tickActive();
            } else if (jbState.isEnabled() && !this.isOnGround(player) && !player.isFallFlying()) {
                double xMotion;
                boolean reallyHovering = jbLocal.canHover() && (!jbLocal.isSmartHover() || jbLocal.isHovering());
                boolean stopped = jbLocal.isFlightStabilizers() && jetbootsCount >= 4 && PneumaticCraftUtils.epsilonEquals(player.zza, 0.0f) && PneumaticCraftUtils.epsilonEquals(player.xxa, 0.0f);
                double d = xMotion = stopped ? 0.0 : player.getDeltaMovement().x;
                double yMotion = reallyHovering ? (player.isShiftKeyDown() ? -0.45 : -0.1 + 0.02 * (double)jetbootsCount) : player.getDeltaMovement().y;
                double zMotion = stopped ? 0.0 : player.getDeltaMovement().z;
                player.setDeltaMovement(new Vec3(xMotion, yMotion, zMotion));
                if (reallyHovering) {
                    player.fallDistance = 0.0f;
                }
                jetbootsAirUsage = reallyHovering ? (int)((float)((Integer)ConfigHelper.common().armor.jetBootsAirUsage.get()).intValue() * (player.isShiftKeyDown() ? 0.25f : 0.5f)) : 0;
                jbLocal.resetAccel();
            } else if (this.isOnGround(player)) {
                jbLocal.setHovering(false);
            } else {
                jbLocal.resetAccel();
            }
        } else {
            if (jbState.isEnabled() && !player.onGround() && !player.isFallFlying() && jbLocal.isHovering()) {
                jetbootsAirUsage = 1;
            }
            this.setJetBootsActive(commonArmorHandler, false);
        }
        if (jetbootsAirUsage != 0 && !player.level().isClientSide) {
            if (jbLocal.getPrevJetBootsAirUsage() == 0) {
                NetworkHandler.sendToAllTracking(new PacketPlayMovingSound(MovingSounds.Sound.JET_BOOTS, PacketPlayMovingSound.MovingSoundFocus.of((Entity)player)), player.level(), player.blockPosition());
                ModCriterionTriggers.FLIGHT.get().trigger((ServerPlayer)player);
            }
            if (player.horizontalCollision) {
                double vel = player.getDeltaMovement().length();
                if (player.level().getDifficulty() == Difficulty.HARD) {
                    vel *= 2.0;
                } else if (player.level().getDifficulty() == Difficulty.NORMAL) {
                    vel *= 1.5;
                }
                if (vel > 2.0) {
                    player.playSound(vel > 2.5 ? SoundEvents.GENERIC_BIG_FALL : SoundEvents.GENERIC_SMALL_FALL, 1.0f, 1.0f);
                    player.hurt(player.damageSources().flyIntoWall(), (float)vel);
                    ModCriterionTriggers.FLY_INTO_WALL.get().trigger((ServerPlayer)player);
                }
            }
            commonArmorHandler.addAir(EquipmentSlot.FEET, -jetbootsAirUsage);
            if (player.position().y > (double)(player.level().getMaxBuildHeight() + 64)) {
                player.getCooldowns().addCooldown((Item)ModItems.PNEUMATIC_BOOTS.get(), 20);
            }
        }
        jbLocal.setPrevJetBootsAirUsage(jetbootsAirUsage);
    }

    private boolean isOnGround(Player player) {
        if (player.onGround()) {
            return true;
        }
        if (!player.level().isClientSide) {
            BlockPos pos = player.getOnPos();
            VoxelShape shape = player.level().getBlockState(pos).getCollisionShape((BlockGetter)player.level(), pos);
            if (!shape.isEmpty()) {
                return player.getBoundingBox().move(0.0, -0.01, 0.0).intersects(shape.bounds().move(pos));
            }
        }
        return false;
    }

    @Override
    public void onInit(ICommonArmorHandler commonArmorHandler) {
        Player player = commonArmorHandler.getPlayer();
        ItemStack armorStack = player.getItemBySlot(EquipmentSlot.FEET);
        JetBootsLocalState jbLocal = commonArmorHandler.getExtensionData(this);
        jbLocal.flightStabilizers = PneumaticArmorItem.getBooleanData(armorStack, "JetBootsStabilizers", false);
        jbLocal.jetBootsPower = (float)PneumaticArmorItem.getIntData(armorStack, "JetBootsPower", 100, 0, 100) / 100.0f;
        jbLocal.hover = PneumaticArmorItem.getBooleanData(armorStack, "Hover", true);
        jbLocal.smartHover = PneumaticArmorItem.getBooleanData(armorStack, "SmartHover", false);
        boolean jetBootsBuilderMode = PneumaticArmorItem.getBooleanData(armorStack, "JetBootsBuilderMode", false);
        JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
        JetBootsStateTracker.getTracker(player).setJetBootsState(player, jbState.isEnabled(), jbState.isActive(), jetBootsBuilderMode);
    }

    @Override
    public void onToggle(ICommonArmorHandler commonArmorHandler, boolean newState) {
        Player player = commonArmorHandler.getPlayer();
        JetBootsStateTracker tracker = JetBootsStateTracker.getTracker(player);
        JetBootsStateTracker.JetBootsState jbs = tracker.getJetBootsState(player);
        tracker.setJetBootsState(player, newState, jbs.isActive(), jbs.isBuilderMode());
        super.onToggle(commonArmorHandler, newState);
    }

    @Override
    public void onShutdown(ICommonArmorHandler commonArmorHandler) {
        this.setJetBootsActive(commonArmorHandler, false);
    }

    @Override
    public void onDataFieldUpdated(ICommonArmorHandler commonArmorHandler, String tagName, Tag inbt) {
        Player player = commonArmorHandler.getPlayer();
        JetBootsLocalState jbLocal = commonArmorHandler.getExtensionData(this);
        switch (tagName) {
            case "JetBootsBuilderMode": {
                JetBootsStateTracker.getTracker(player).getJetBootsState(player).setBuilderMode(((ByteTag)inbt).getAsByte() == 1);
                break;
            }
            case "JetBootsPower": {
                jbLocal.jetBootsPower = Mth.clamp((float)((float)((IntTag)inbt).getAsInt() / 100.0f), (float)0.0f, (float)1.0f);
                break;
            }
            case "JetBootsStabilizers": {
                jbLocal.flightStabilizers = ((ByteTag)inbt).getAsByte() == 1;
                break;
            }
            case "Hover": {
                jbLocal.hover = ((ByteTag)inbt).getAsByte() == 1;
                break;
            }
            case "SmartHover": {
                jbLocal.smartHover = ((ByteTag)inbt).getAsByte() == 1;
            }
        }
    }

    public void setJetBootsActive(ICommonArmorHandler commonArmorHandler, boolean newActive) {
        Player player = commonArmorHandler.getPlayer();
        JetBootsStateTracker.JetBootsState jbs = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
        JetBootsLocalState jbLocal = commonArmorHandler.getExtensionData(this);
        if (!newActive) {
            jbLocal.resetActive();
            if (jbLocal.isFlightStabilizers() && jbs.isActive() && !jbs.isBuilderMode()) {
                if (!player.level().isClientSide) {
                    double l = Math.pow(player.getDeltaMovement().length(), 1.65);
                    commonArmorHandler.addAir(EquipmentSlot.FEET, (int)(l * -50.0));
                    NetworkHandler.sendToAllTracking(new PacketSpawnParticle((ParticleOptions)AirParticleData.DENSE, player.getX(), player.getY(), player.getZ(), 0.0, 0.0, 0.0, (int)(l * 2.0), 0.0, 0.0, 0.0), player.level(), player.blockPosition());
                }
                player.setDeltaMovement(Vec3.ZERO);
            }
        }
        if (jbLocal.isSmartHover()) {
            jbLocal.setHovering(true);
        }
        JetBootsStateTracker.getTracker(player).setJetBootsState(player, jbs.isEnabled(), newActive, jbs.isBuilderMode());
        player.setForcedPose(newActive && !jbs.isBuilderMode() ? Pose.FALL_FLYING : null);
    }

    private void setYMotion(Entity entity, double y) {
        Vec3 v = entity.getDeltaMovement();
        v = v.add(0.0, y - v.y, 0.0);
        entity.setDeltaMovement(v);
    }

    public JetBootsStateTracker.JetBootsState getJetBootsSyncedState(ICommonArmorHandler commonArmorHandler) {
        return JetBootsStateTracker.getTracker(commonArmorHandler.getPlayer()).getJetBootsState(commonArmorHandler.getPlayer());
    }

    public static class JetBootsLocalState
    implements IArmorExtensionData {
        public boolean hover;
        public boolean smartHover;
        public boolean flightStabilizers;
        public float jetBootsPower;
        private float flightAccel = 1.0f;
        private int prevJetBootsAirUsage;
        private int jetBootsActiveTicks;
        private boolean hovering;

        public void tickActive() {
            ++this.jetBootsActiveTicks;
        }

        public void resetActive() {
            this.jetBootsActiveTicks = 0;
        }

        public void updateAccel(Vec3 lookVec) {
            float div = lookVec.y > 0.0 ? -64.0f : -16.0f;
            this.flightAccel = Mth.clamp((float)(this.flightAccel + (float)lookVec.y / div), (float)0.8f, (float)4.2f);
        }

        public Vec3 getEffectiveMotion(Vec3 lookVec, boolean gliding) {
            lookVec = lookVec.scale((double)(this.flightAccel * this.jetBootsPower));
            if (!gliding && this.jetBootsActiveTicks < 20 && this.jetBootsActiveTicks > 0) {
                lookVec = lookVec.scale((double)this.jetBootsActiveTicks * 0.05);
            }
            return lookVec;
        }

        public boolean isHovering() {
            return this.hovering;
        }

        public void setHovering(boolean hovering) {
            this.hovering = hovering;
        }

        public int getPrevJetBootsAirUsage() {
            return this.prevJetBootsAirUsage;
        }

        public void setPrevJetBootsAirUsage(int prevJetBootsAirUsage) {
            this.prevJetBootsAirUsage = prevJetBootsAirUsage;
        }

        public void resetAccel() {
            this.flightAccel = 1.0f;
        }

        public int calcAirUsage(int jetbootsCount) {
            return (int)((float)((Integer)ConfigHelper.common().armor.jetBootsAirUsage.get() * jetbootsCount) * this.jetBootsPower);
        }

        public boolean canHover() {
            return this.hover;
        }

        public boolean isSmartHover() {
            return this.smartHover;
        }

        public boolean isFlightStabilizers() {
            return this.flightStabilizers;
        }
    }
}

