/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.UUID;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.BuiltinArmorUpgrades;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.NeoForgeMod;

public class ReachDistanceHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    private static final UUID REACH_DIST_BOOST_ID = UUID.fromString("c9dce729-70c4-4c0f-95d4-31d2e50bc826");
    public static final AttributeModifier REACH_DIST_BOOST = new AttributeModifier(REACH_DIST_BOOST_ID, "Pneumatic Reach Boost", 3.5, AttributeModifier.Operation.ADDITION);

    @Override
    public ResourceLocation getID() {
        return BuiltinArmorUpgrades.REACH_DISTANCE;
    }

    @Override
    public PNCUpgrade[] getRequiredUpgrades() {
        return new PNCUpgrade[]{ModUpgrades.RANGE.get()};
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 5.0f;
    }

    @Override
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.CHEST;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        AttributeInstance attr;
        Player player = commonArmorHandler.getPlayer();
        if ((player.level().getGameTime() & 0xFL) == 0L && (attr = player.getAttribute((Attribute)NeoForgeMod.BLOCK_REACH.value())) != null) {
            attr.removeModifier(REACH_DIST_BOOST_ID);
            if (enabled && commonArmorHandler.hasMinPressure(EquipmentSlot.CHEST) && commonArmorHandler.isArmorEnabled()) {
                attr.addTransientModifier(REACH_DIST_BOOST);
            }
        }
    }

    @Override
    public void onToggle(ICommonArmorHandler commonArmorHandler, boolean newState) {
        AttributeInstance attr;
        if (!newState && (attr = commonArmorHandler.getPlayer().getAttribute((Attribute)NeoForgeMod.BLOCK_REACH.value())) != null) {
            attr.removeModifier(REACH_DIST_BOOST_ID);
        }
    }

    @Override
    public void onShutdown(ICommonArmorHandler commonArmorHandler) {
        AttributeInstance attr = commonArmorHandler.getPlayer().getAttribute((Attribute)NeoForgeMod.BLOCK_REACH.value());
        if (attr != null) {
            attr.removeModifier(REACH_DIST_BOOST_ID);
        }
    }
}

