/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class ModCraftingHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static FluidStack fluidStackFromJson(JsonObject json) {
        String fluidName = GsonHelper.getAsString((JsonObject)json, (String)"fluid");
        if (fluidName.equals("minecraft:empty")) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(new ResourceLocation(fluidName));
        if (fluid == Fluids.EMPTY) {
            throw new JsonSyntaxException("unknown fluid: " + fluidName);
        }
        int amount = GsonHelper.getAsInt((JsonObject)json, (String)"amount", (int)1000);
        FluidStack fluidStack = new FluidStack(fluid, amount);
        if (json.has("nbt")) {
            JsonElement element = json.get("nbt");
            try {
                if (element.isJsonObject()) {
                    fluidStack.setTag(TagParser.parseTag((String)GSON.toJson(element)));
                } else {
                    fluidStack.setTag(TagParser.parseTag((String)GsonHelper.convertToString((JsonElement)element, (String)"nbt")));
                }
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException((Throwable)e);
            }
        }
        return fluidStack;
    }

    public static JsonObject fluidStackToJson(FluidStack f) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", PneumaticCraftUtils.getRegistryName(f.getFluid()).orElseThrow().toString());
        json.addProperty("amount", (Number)f.getAmount());
        if (f.hasTag()) {
            json.addProperty("nbt", f.getTag().toString());
        }
        return json;
    }

    public static List<ItemStack> findItems(CraftingContainer inv, List<Predicate<ItemStack>> predicates) {
        ArrayList<ItemStack> res = new ArrayList<ItemStack>();
        BitSet matchedSlots = new BitSet(inv.getContainerSize());
        for (Predicate<ItemStack> pred : predicates) {
            boolean found = false;
            for (int i = 0; i < inv.getContainerSize(); ++i) {
                ItemStack stack;
                if (matchedSlots.get(i) || !pred.test(stack = inv.getItem(i))) continue;
                res.add(stack);
                matchedSlots.set(i);
                found = true;
                break;
            }
            if (found) continue;
            return List.of();
        }
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            if (matchedSlots.get(i) || inv.getItem(i).isEmpty()) continue;
            return List.of();
        }
        return res;
    }

    public static boolean allPresent(CraftingContainer inv, List<Predicate<ItemStack>> predicates) {
        return ModCraftingHelper.findItems(inv, predicates).size() == predicates.size();
    }
}

