/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.amadron;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.OfferType;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.playerfilter.PlayerFilter;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.trading.MerchantOffer;

public class AmadronOffer
extends AmadronRecipe {
    @Nonnull
    private final ResourceLocation offerId;
    @Nonnull
    protected final AmadronTradeResource input;
    @Nonnull
    protected final AmadronTradeResource output;
    protected final PlayerFilter whitelist;
    protected final PlayerFilter blacklist;
    private final boolean staticOffer;
    private final boolean villagerTrade;
    private final int tradeLevel;
    private final int maxStock;
    protected int inStock;

    public AmadronOffer(@Nonnull ResourceLocation offerId, @Nonnull AmadronTradeResource input, @Nonnull AmadronTradeResource output, boolean staticOffer, boolean villagerTrade, int tradeLevel, int maxStock, int inStock, PlayerFilter whitelist, PlayerFilter blacklist) {
        this.offerId = offerId;
        this.input = Objects.requireNonNull(input).validate();
        this.output = Objects.requireNonNull(output).validate();
        this.staticOffer = staticOffer;
        this.villagerTrade = villagerTrade;
        this.tradeLevel = tradeLevel;
        this.maxStock = maxStock;
        this.inStock = inStock;
        this.whitelist = whitelist;
        this.blacklist = blacklist;
    }

    public static AmadronOffer villagerTrade(ResourceLocation offerId, MerchantOffer merchantOffer, int level) {
        return new AmadronOffer(offerId, AmadronTradeResource.of(merchantOffer.getBaseCostA()), AmadronTradeResource.of(merchantOffer.getResult()), false, true, level, merchantOffer.getMaxUses(), merchantOffer.getMaxUses(), PlayerFilter.YES, PlayerFilter.NO);
    }

    public ResourceLocation getOfferId() {
        return this.offerId;
    }

    public OfferType getOfferType() {
        return this.isVillagerTrade() ? OfferType.VILLAGER : OfferType.RECIPE;
    }

    @Override
    @Nonnull
    public AmadronTradeResource getInput() {
        return this.input;
    }

    @Override
    @Nonnull
    public AmadronTradeResource getOutput() {
        return this.output;
    }

    @Override
    public boolean isStaticOffer() {
        return this.staticOffer;
    }

    @Override
    public int getTradeLevel() {
        return this.tradeLevel;
    }

    public boolean equivalentTo(AmadronPlayerOffer offer) {
        return this.input.equivalentTo(offer.getInput()) && this.output.equivalentTo(offer.getOutput());
    }

    @Override
    public Component getVendorName() {
        return PneumaticCraftUtils.xlate(this.villagerTrade ? "pneumaticcraft.gui.amadron.villager" : "pneumaticcraft.gui.amadron", new Object[0]);
    }

    @Override
    public int getStock() {
        return this.inStock;
    }

    @Override
    public void setStock(int inStock) {
        int max;
        int n = max = this.maxStock > 0 ? this.maxStock : Integer.MAX_VALUE;
        if (inStock < 0 || inStock > max) {
            Log.warning("Amadron Offer {}: new stock {} out of range (0,{}) - clamped", this, inStock, this.maxStock);
        }
        this.inStock = Mth.clamp((int)inStock, (int)0, (int)max);
    }

    public void onTrade(int tradingAmount, String buyingPlayer) {
    }

    public static AmadronOffer offerFromBuf(FriendlyByteBuf buf) {
        return (AmadronOffer)ModRecipeSerializers.AMADRON_OFFERS.get().fromNetwork(buf);
    }

    public String toString() {
        return String.format("[in = %s, out = %s, level = %d, maxStock = %d]", this.input, this.output, this.tradeLevel, this.maxStock);
    }

    public Component getDescription() {
        return Component.literal((String)String.format("[%s -> %s]", this.input, this.output));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AmadronOffer)) {
            return false;
        }
        AmadronOffer that = (AmadronOffer)o;
        return this.input.equals(that.input) && this.output.equals(that.output);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.output);
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.AMADRON_OFFERS.get();
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.AMADRON.get();
    }

    @Override
    public int getMaxStock() {
        return this.maxStock;
    }

    @Override
    public boolean isVillagerTrade() {
        return this.villagerTrade;
    }

    @Override
    public PlayerFilter getWhitelist() {
        return this.whitelist;
    }

    @Override
    public PlayerFilter getBlacklist() {
        return this.blacklist;
    }

    @Override
    public boolean isUsableByPlayer(Player player) {
        return this.whitelist.test(player) && !this.blacklist.test(player);
    }

    @Override
    public void addAvailabilityData(Player player, List<Component> curTip) {
        MutableComponent suffix;
        if (this.whitelist.isReal()) {
            suffix = PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc." + (this.whitelist.matchAll() ? "all" : "any"), new Object[0]);
            curTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.whitelist", new Object[0]).append(" (").append((Component)suffix).append(")").withStyle(ChatFormatting.GOLD));
            this.whitelist.getDescription(player, curTip);
        }
        if (this.blacklist.isReal()) {
            suffix = PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc." + (this.blacklist.matchAll() ? "all" : "any"), new Object[0]);
            curTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.blacklist", new Object[0]).append(" (").append((Component)suffix).append(")").withStyle(ChatFormatting.GOLD));
            this.blacklist.getDescription(player, curTip);
        }
    }

    @Override
    public boolean isLocationLimited() {
        return this.whitelist.isReal() || this.blacklist.isReal();
    }

    public void write(FriendlyByteBuf buf) {
        ModRecipeSerializers.AMADRON_OFFERS.get().toNetwork(buf, (Recipe)this);
    }

    public static class Serializer<T extends AmadronOffer>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;
        private final Codec<T> codec;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("offer_id").forGetter(AmadronOffer::getOfferId), (App)AmadronTradeResource.CODEC.fieldOf("input").forGetter(AmadronOffer::getInput), (App)AmadronTradeResource.CODEC.fieldOf("output").forGetter(AmadronOffer::getOutput), (App)Codec.BOOL.optionalFieldOf("static", (Object)true).forGetter(AmadronOffer::isStaticOffer), (App)Codec.BOOL.optionalFieldOf("villager_trade", (Object)false).forGetter(AmadronOffer::isVillagerTrade), (App)Codec.INT.optionalFieldOf("level", (Object)1).forGetter(AmadronOffer::getTradeLevel), (App)Codec.INT.optionalFieldOf("maxStock", (Object)-1).forGetter(AmadronOffer::getMaxStock), (App)Codec.INT.optionalFieldOf("inStock", (Object)-1).forGetter(AmadronOffer::getStock), (App)PlayerFilter.CODEC.optionalFieldOf("whitelist", (Object)PlayerFilter.YES).forGetter(AmadronOffer::getWhitelist), (App)PlayerFilter.CODEC.optionalFieldOf("blacklist", (Object)PlayerFilter.NO).forGetter(AmadronOffer::getBlacklist)).apply((Applicative)inst, factory::create));
        }

        public Codec<T> codec() {
            return this.codec;
        }

        public T fromNetwork(FriendlyByteBuf buffer) {
            return (T)((AmadronOffer)this.factory.create(buffer.readResourceLocation(), AmadronTradeResource.fromNetwork(buffer), AmadronTradeResource.fromNetwork(buffer), buffer.readBoolean(), buffer.readBoolean(), buffer.readByte(), buffer.readVarInt(), buffer.readVarInt(), PlayerFilter.fromNetwork(buffer), PlayerFilter.fromNetwork(buffer)));
        }

        public void toNetwork(FriendlyByteBuf buf, T recipe) {
            buf.writeResourceLocation(((AmadronOffer)recipe).getOfferId());
            ((AmadronOffer)recipe).getInput().toNetwork(buf);
            ((AmadronOffer)recipe).getOutput().toNetwork(buf);
            buf.writeBoolean(((AmadronOffer)recipe).isStaticOffer());
            buf.writeBoolean(((AmadronOffer)recipe).isVillagerTrade());
            buf.writeByte(((AmadronOffer)recipe).getTradeLevel());
            buf.writeVarInt(((AmadronOffer)recipe).getMaxStock());
            buf.writeVarInt(((AmadronOffer)recipe).getStock());
            ((AmadronOffer)recipe).getWhitelist().toNetwork(buf);
            ((AmadronOffer)recipe).getBlacklist().toNetwork(buf);
        }

        public static interface IFactory<T extends AmadronRecipe> {
            public T create(ResourceLocation var1, AmadronTradeResource var2, AmadronTradeResource var3, boolean var4, boolean var5, int var6, int var7, int var8, PlayerFilter var9, PlayerFilter var10);
        }
    }
}

