/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.amadron;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.RecipeHolder;

public enum OfferType {
    RECIPE((buf, offer) -> offer.write((FriendlyByteBuf)buf), buf -> Optional.of(AmadronOffer.offerFromBuf(buf))),
    VILLAGER((buf, offer) -> offer.write((FriendlyByteBuf)buf), buf -> Optional.of(AmadronOffer.offerFromBuf(buf))),
    PLAYER((buf, offer) -> offer.write((FriendlyByteBuf)buf), buf -> Optional.ofNullable(AmadronPlayerOffer.playerOfferFromBuf(buf)));

    private final BiConsumer<FriendlyByteBuf, AmadronOffer> writer;
    private final Function<FriendlyByteBuf, Optional<AmadronOffer>> reader;

    private OfferType(BiConsumer<FriendlyByteBuf, AmadronOffer> writer, Function<FriendlyByteBuf, Optional<AmadronOffer>> reader) {
        this.writer = writer;
        this.reader = reader;
    }

    public void write(FriendlyByteBuf buf, AmadronOffer offer) {
        this.writer.accept(buf, offer);
    }

    public Optional<AmadronOffer> read(FriendlyByteBuf buf) {
        return this.reader.apply(buf);
    }

    private static Optional<AmadronOffer> fromHolder(Optional<RecipeHolder<AmadronRecipe>> holder) {
        return holder.filter(r -> r.value() instanceof AmadronOffer).map(r -> (AmadronOffer)r.value());
    }
}

