/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class AssemblyRecipeImpl
extends AssemblyRecipe {
    private final Ingredient input;
    private final ItemStack output;
    private final AssemblyRecipe.AssemblyProgramType program;

    public AssemblyRecipeImpl(@Nonnull Ingredient input, @Nonnull ItemStack output, AssemblyRecipe.AssemblyProgramType program) {
        this.input = input;
        this.output = output;
        this.program = program;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public int getInputAmount() {
        return this.input.getItems().length > 0 ? this.input.getItems()[0].getCount() : 0;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public AssemblyRecipe.AssemblyProgramType getProgramType() {
        return this.program;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack) && stack.getCount() >= this.getInputAmount();
    }

    public RecipeSerializer<?> getSerializer() {
        return switch (this.getProgramType()) {
            case AssemblyRecipe.AssemblyProgramType.LASER -> ModRecipeSerializers.ASSEMBLY_LASER.get();
            case AssemblyRecipe.AssemblyProgramType.DRILL -> ModRecipeSerializers.ASSEMBLY_DRILL.get();
            default -> throw new IllegalStateException("invalid program type: " + this.getProgramType());
        };
    }

    public RecipeType<?> getType() {
        return switch (this.getProgramType()) {
            default -> throw new IncompatibleClassChangeError();
            case AssemblyRecipe.AssemblyProgramType.DRILL -> ModRecipeTypes.ASSEMBLY_DRILL.get();
            case AssemblyRecipe.AssemblyProgramType.LASER -> ModRecipeTypes.ASSEMBLY_LASER.get();
            case AssemblyRecipe.AssemblyProgramType.DRILL_LASER -> ModRecipeTypes.ASSEMBLY_DRILL_LASER.get();
        };
    }

    public static Map<ResourceLocation, RecipeHolder<AssemblyRecipe>> calculateAssemblyChain(List<RecipeHolder<AssemblyRecipe>> drillRecipes, List<RecipeHolder<AssemblyRecipe>> laserRecipes) {
        HashMap<ResourceLocation, RecipeHolder<AssemblyRecipe>> drillLaser = new HashMap<ResourceLocation, RecipeHolder<AssemblyRecipe>>();
        for (RecipeHolder<AssemblyRecipe> h1 : drillRecipes) {
            for (RecipeHolder<AssemblyRecipe> h2 : laserRecipes) {
                AssemblyRecipe r1 = (AssemblyRecipe)h1.value();
                AssemblyRecipe r2 = (AssemblyRecipe)h2.value();
                if (!r2.getInput().test(r1.getOutput()) || r1.getOutput().getCount() % r2.getInputAmount() != 0 || r2.getOutput().getMaxStackSize() < r2.getOutput().getCount() * (r1.getOutput().getCount() / r2.getInputAmount())) continue;
                ItemStack output = r2.getOutput().copy();
                output.setCount(output.getCount() * (r1.getOutput().getCount() / r2.getInputAmount()));
                ResourceLocation id = PneumaticRegistry.RL(h1.id().getPath() + "_" + h2.id().getPath());
                drillLaser.put(id, (RecipeHolder<AssemblyRecipe>)new RecipeHolder(id, (Recipe)new AssemblyRecipeImpl(r1.getInput(), output, AssemblyRecipe.AssemblyProgramType.DRILL_LASER)));
            }
        }
        return drillLaser;
    }

    public static class Serializer<T extends AssemblyRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;
        private final Codec<T> codec;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.create(inst -> inst.group((App)Ingredient.CODEC.fieldOf("input").forGetter(AssemblyRecipe::getInput), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter(AssemblyRecipe::getOutput), (App)ExtraCodecs.validate(AssemblyRecipe.AssemblyProgramType.CODEC, Serializer::checkNotDrillAndLaser).fieldOf("program").forGetter(AssemblyRecipe::getProgramType)).apply((Applicative)inst, factory::create));
        }

        @NotNull
        private static DataResult<AssemblyRecipe.AssemblyProgramType> checkNotDrillAndLaser(AssemblyRecipe.AssemblyProgramType type) {
            return type == AssemblyRecipe.AssemblyProgramType.DRILL_LASER ? DataResult.error(() -> "'drill_laser' may not be used as a recipe type!") : DataResult.success((Object)((Object)type));
        }

        public Codec<T> codec() {
            return this.codec;
        }

        public T fromNetwork(FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
            ItemStack out = buffer.readItem();
            AssemblyRecipe.AssemblyProgramType program = (AssemblyRecipe.AssemblyProgramType)buffer.readEnum(AssemblyRecipe.AssemblyProgramType.class);
            return this.factory.create(input, out, program);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((AssemblyRecipe)recipe).getInput().toNetwork(buffer);
            buffer.writeItem(((AssemblyRecipe)recipe).getOutput());
            buffer.writeEnum((Enum)((AssemblyRecipe)recipe).getProgramType());
        }

        public static interface IFactory<T extends AssemblyRecipe> {
            public T create(@Nonnull Ingredient var1, @Nonnull ItemStack var2, AssemblyRecipe.AssemblyProgramType var3);
        }
    }
}

