/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import me.desht.pneumaticcraft.api.crafting.recipe.ExplosionCraftingRecipe;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class ExplosionCraftingRecipeImpl
extends ExplosionCraftingRecipe {
    private static final NonNullList<ItemStack> EMPTY_RESULT = NonNullList.create();
    private final Ingredient input;
    private final List<ItemStack> outputs;
    private final int lossRate;

    public ExplosionCraftingRecipeImpl(Ingredient input, int lossRate, List<ItemStack> outputs) {
        this.input = input;
        this.outputs = outputs;
        this.lossRate = lossRate;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public int getAmount() {
        return this.input.getItems().length > 0 ? this.input.getItems()[0].getCount() : 0;
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public int getLossRate() {
        return this.lossRate;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack) && stack.getCount() >= this.getAmount();
    }

    public static NonNullList<ItemStack> tryToCraft(Level world, ItemStack stack) {
        return ModRecipeTypes.EXPLOSION_CRAFTING.get().findFirst(world, r -> r.matches(stack)).map(holder -> {
            ExplosionCraftingRecipe recipe = (ExplosionCraftingRecipe)holder.value();
            return recipe.getAmount() == 0 ? EMPTY_RESULT : ExplosionCraftingRecipeImpl.createOutput(recipe, stack);
        }).orElse(EMPTY_RESULT);
    }

    private static NonNullList<ItemStack> createOutput(ExplosionCraftingRecipe recipe, ItemStack stack) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int lossRate = recipe.getLossRate();
        NonNullList res = NonNullList.create();
        int inputCount = Math.round((float)stack.getCount() / (float)recipe.getAmount());
        if (inputCount >= 3 || ((Random)rand).nextDouble() >= (double)lossRate / 100.0) {
            for (ItemStack s : recipe.getOutputs()) {
                ItemStack newStack = s.copy();
                if (inputCount >= 3) {
                    newStack.setCount((int)((double)inputCount * (((Random)rand).nextDouble() * Math.min((double)lossRate * 0.02, 0.2) + (Math.max(0.9, 1.0 - (double)lossRate * 0.01) - (double)lossRate * 0.01))));
                }
                res.add((Object)newStack);
            }
        }
        return res;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.EXPLOSION_CRAFTING.get();
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.EXPLOSION_CRAFTING.get();
    }

    public String getGroup() {
        return "explosion_crafting";
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)Blocks.TNT);
    }

    public static class Serializer<T extends ExplosionCraftingRecipe>
    implements RecipeSerializer<T> {
        private final Codec<T> codec;
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC.fieldOf("input").forGetter(ExplosionCraftingRecipe::getInput), (App)ExtraCodecs.intRange((int)0, (int)99).fieldOf("loss_rate").forGetter(ExplosionCraftingRecipe::getLossRate), (App)ItemStack.ITEM_WITH_COUNT_CODEC.listOf().fieldOf("results").forGetter(ExplosionCraftingRecipe::getOutputs)).apply((Applicative)builder, factory::create));
        }

        public Codec<T> codec() {
            return this.codec;
        }

        public T fromNetwork(FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
            List l = buffer.readList(FriendlyByteBuf::readItem);
            int lossRate = buffer.readVarInt();
            return this.factory.create(input, lossRate, l);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((ExplosionCraftingRecipe)recipe).getInput().toNetwork(buffer);
            buffer.writeCollection(((ExplosionCraftingRecipe)recipe).getOutputs(), FriendlyByteBuf::writeItem);
            buffer.writeVarInt(((ExplosionCraftingRecipe)recipe).getLossRate());
        }

        public static interface IFactory<T extends ExplosionCraftingRecipe> {
            public T create(Ingredient var1, int var2, List<ItemStack> var3);
        }
    }
}

