/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.FluidMixerRecipe;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidMixerRecipeImpl
extends FluidMixerRecipe {
    private final FluidIngredient input1;
    private final FluidIngredient input2;
    private final FluidStack outputFluid;
    private final ItemStack outputItem;
    private final float pressure;
    private final int processingTime;

    public FluidMixerRecipeImpl(FluidIngredient input1, FluidIngredient input2, FluidStack outputFluid, ItemStack outputItem, float pressure, int processingTime) {
        this.input1 = input1;
        this.input2 = input2;
        this.outputFluid = outputFluid;
        this.outputItem = outputItem;
        this.pressure = pressure;
        this.processingTime = processingTime;
    }

    @Override
    public boolean matches(FluidStack fluid1, FluidStack fluid2) {
        return this.input1.testFluid(fluid1) && this.input2.testFluid(fluid2) || this.input2.testFluid(fluid1) && this.input1.testFluid(fluid2);
    }

    @Override
    public FluidIngredient getInput1() {
        return this.input1;
    }

    @Override
    public FluidIngredient getInput2() {
        return this.input2;
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    @Override
    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public float getRequiredPressure() {
        return this.pressure;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.FLUID_MIXER.get();
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.FLUID_MIXER.get();
    }

    public static class Serializer<T extends FluidMixerRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;
        private final Codec<T> codec;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.create(builder -> builder.group((App)FluidIngredient.FLUID_CODEC.fieldOf("input1").forGetter(FluidMixerRecipe::getInput1), (App)FluidIngredient.FLUID_CODEC.fieldOf("input2").forGetter(FluidMixerRecipe::getInput2), (App)FluidStack.CODEC.fieldOf("fluid_output").forGetter(FluidMixerRecipe::getOutputFluid), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("item_output").forGetter(FluidMixerRecipe::getOutputItem), (App)Codec.FLOAT.fieldOf("pressure").forGetter(FluidMixerRecipe::getRequiredPressure), (App)Codec.INT.fieldOf("time").forGetter(FluidMixerRecipe::getProcessingTime)).apply((Applicative)builder, factory::create));
        }

        public Codec<T> codec() {
            return this.codec;
        }

        public T fromNetwork(FriendlyByteBuf buffer) {
            FluidIngredient input1 = FluidIngredient.fluidFromNetwork(buffer);
            FluidIngredient input2 = FluidIngredient.fluidFromNetwork(buffer);
            FluidStack outputFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            ItemStack outputItem = buffer.readItem();
            float pressure = buffer.readFloat();
            int processingTime = buffer.readVarInt();
            return this.factory.create(input1, input2, outputFluid, outputItem, pressure, processingTime);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((FluidMixerRecipe)recipe).getInput1().fluidToNetwork(buffer);
            ((FluidMixerRecipe)recipe).getInput2().fluidToNetwork(buffer);
            ((FluidMixerRecipe)recipe).getOutputFluid().writeToPacket(buffer);
            buffer.writeItem(((FluidMixerRecipe)recipe).getOutputItem());
            buffer.writeFloat(((FluidMixerRecipe)recipe).getRequiredPressure());
            buffer.writeVarInt(((FluidMixerRecipe)recipe).getProcessingTime());
        }

        public static interface IFactory<T extends FluidMixerRecipe> {
            public T create(FluidIngredient var1, FluidIngredient var2, FluidStack var3, ItemStack var4, float var5, int var6);
        }
    }
}

