/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class HeatFrameCoolingRecipeImpl
extends HeatFrameCoolingRecipe {
    private static int maxThresholdTemp = Integer.MIN_VALUE;
    public final Ingredient input;
    private final int temperature;
    public final ItemStack output;
    private final float bonusMultiplier;
    private final float bonusLimit;

    public HeatFrameCoolingRecipeImpl(Ingredient input, int temperature, ItemStack output) {
        this(input, temperature, output, 0.0f, 0.0f);
    }

    public HeatFrameCoolingRecipeImpl(Ingredient input, int temperature, ItemStack output, float bonusMultiplier, float bonusLimit) {
        this.input = input;
        this.temperature = temperature;
        this.output = output;
        this.bonusMultiplier = bonusMultiplier;
        this.bonusLimit = bonusLimit;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public int getThresholdTemperature() {
        return this.temperature;
    }

    @Override
    public float getBonusMultiplier() {
        return this.bonusMultiplier;
    }

    @Override
    public float getBonusLimit() {
        return this.bonusLimit;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.HEAT_FRAME_COOLING.get();
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.HEAT_FRAME_COOLING.get();
    }

    public static <T extends Recipe<?>> void cacheMaxThresholdTemp(Collection<RecipeHolder<T>> recipes) {
        maxThresholdTemp = Integer.MIN_VALUE;
        for (RecipeHolder<T> holder : recipes) {
            HeatFrameCoolingRecipe hfcr;
            Recipe recipe = holder.value();
            if (!(recipe instanceof HeatFrameCoolingRecipe) || (hfcr = (HeatFrameCoolingRecipe)recipe).getThresholdTemperature() <= maxThresholdTemp) continue;
            maxThresholdTemp = hfcr.getThresholdTemperature();
        }
    }

    public static int getMaxThresholdTemp(Level world) {
        if (maxThresholdTemp == Integer.MIN_VALUE) {
            HeatFrameCoolingRecipeImpl.cacheMaxThresholdTemp(ModRecipeTypes.getRecipes(world, ModRecipeTypes.HEAT_FRAME_COOLING));
        }
        return maxThresholdTemp;
    }

    public static class Serializer<T extends HeatFrameCoolingRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;
        private final Codec<T> codec;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.create(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(HeatFrameCoolingRecipe::getInput), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("temperature").forGetter(HeatFrameCoolingRecipe::getThresholdTemperature), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("output").forGetter(HeatFrameCoolingRecipe::getOutput), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("bonusMultiplier", (Object)Float.valueOf(0.0f)).forGetter(HeatFrameCoolingRecipe::getBonusMultiplier), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("bonusLimit", (Object)Float.valueOf(0.0f)).forGetter(HeatFrameCoolingRecipe::getBonusLimit)).apply((Applicative)inst, factory::create));
        }

        public Codec<T> codec() {
            return this.codec;
        }

        public T fromNetwork(FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
            int temperature = buffer.readInt();
            ItemStack out = buffer.readItem();
            float bonusMultiplier = buffer.readFloat();
            float bonusLimit = buffer.readFloat();
            return this.factory.create(input, temperature, out, bonusMultiplier, bonusLimit);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((HeatFrameCoolingRecipe)recipe).getInput().toNetwork(buffer);
            buffer.writeInt(((HeatFrameCoolingRecipe)recipe).getThresholdTemperature());
            buffer.writeItem(((HeatFrameCoolingRecipe)recipe).getOutput());
            buffer.writeFloat(((HeatFrameCoolingRecipe)recipe).getBonusMultiplier());
            buffer.writeFloat(((HeatFrameCoolingRecipe)recipe).getBonusLimit());
        }

        public static interface IFactory<T extends HeatFrameCoolingRecipe> {
            public T create(Ingredient var1, int var2, ItemStack var3, float var4, float var5);
        }
    }
}

