/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.crafting.ingredient.StackedIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class PressureChamberRecipeImpl
extends PressureChamberRecipe {
    private final float pressureRequired;
    private final List<StackedIngredient> inputs;
    private final List<ItemStack> outputs;

    public PressureChamberRecipeImpl(List<StackedIngredient> inputs, float pressureRequired, List<ItemStack> outputs) {
        this.inputs = ImmutableList.copyOf(inputs);
        this.outputs = List.copyOf(outputs);
        this.pressureRequired = pressureRequired;
    }

    @Override
    public float getPressure() {
        return this.pressureRequired;
    }

    @Override
    public List<StackedIngredient> getInputs() {
        return this.inputs;
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public float getCraftingPressure(IItemHandler chamberHandler, IntList ingredientSlots) {
        return this.pressureRequired;
    }

    @Override
    public float getCraftingPressureForDisplay() {
        return this.pressureRequired;
    }

    @Override
    public IntCollection findIngredients(IItemHandler chamberHandler) {
        Set inputSet = Sets.newIdentityHashSet();
        inputSet.addAll(this.inputs);
        IntArrayList slots = new IntArrayList();
        for (int i = 0; i < chamberHandler.getSlots(); ++i) {
            if (chamberHandler.getStackInSlot(i).isEmpty()) continue;
            Iterator iter = inputSet.iterator();
            while (iter.hasNext()) {
                Ingredient ingr = (Ingredient)iter.next();
                if (!ingr.test(chamberHandler.getStackInSlot(i))) continue;
                iter.remove();
                slots.add(i);
                break;
            }
            if (slots.size() != this.inputs.size()) continue;
            return slots;
        }
        return IntList.of();
    }

    @Override
    public List<Ingredient> getInputsForDisplay() {
        return new ArrayList<Ingredient>(this.inputs);
    }

    @Override
    protected List<ItemStack> getSingleResultsForDisplay() {
        return this.outputs;
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.PRESSURE_CHAMBER.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.PRESSURE_CHAMBER.get();
    }

    public String getGroup() {
        return "pneumaticcraft:pressure_chamber";
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.PRESSURE_CHAMBER_WALL.get());
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        ItemStack s2 = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.getMaxStackSize());
        return this.inputs.stream().anyMatch(ingr -> ingr.test(s2));
    }

    @Override
    @Nonnull
    public List<ItemStack> craftRecipe(@Nonnull IItemHandler chamberHandler, IntList ingredientSlots, boolean simulate) {
        for (Ingredient ingredient : this.inputs) {
            if (ingredient.isEmpty()) {
                return NonNullList.create();
            }
            int nItems = ingredient.getItems()[0].getCount();
            for (int i = 0; i < ingredientSlots.size() && nItems > 0; ++i) {
                int slot = ingredientSlots.getInt(i);
                if (!ingredient.test(chamberHandler.getStackInSlot(slot))) continue;
                ItemStack extracted = chamberHandler.extractItem(slot, nItems, simulate);
                nItems -= extracted.getCount();
            }
        }
        return this.outputs;
    }

    public static class Serializer<T extends PressureChamberRecipe>
    implements RecipeSerializer<T> {
        private final Codec<T> codec;
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.create(builder -> builder.group((App)StackedIngredient.CODEC.listOf().fieldOf("inputs").forGetter(PressureChamberRecipe::getInputs), (App)Codec.floatRange((float)-1.0f, (float)5.0f).fieldOf("pressure").forGetter(PressureChamberRecipe::getPressure), (App)ItemStack.ITEM_WITH_COUNT_CODEC.listOf().fieldOf("results").forGetter(PressureChamberRecipe::getOutputs)).apply((Applicative)builder, factory::create));
        }

        public Codec<T> codec() {
            return this.codec;
        }

        public T fromNetwork(FriendlyByteBuf buffer) {
            float pressure = buffer.readFloat();
            List in = buffer.readList(StackedIngredient::fromNetwork);
            List out = buffer.readList(FriendlyByteBuf::readItem);
            return this.factory.create(in, pressure, out);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            buffer.writeFloat(((PressureChamberRecipe)recipe).getCraftingPressureForDisplay());
            buffer.writeCollection(((PressureChamberRecipe)recipe).getInputs(), (buf, ingredient) -> ingredient.toNetwork(buf));
            buffer.writeCollection(((PressureChamberRecipe)recipe).getOutputs(), FriendlyByteBuf::writeItem);
        }

        public static interface IFactory<T extends PressureChamberRecipe> {
            public T create(List<StackedIngredient> var1, float var2, List<ItemStack> var3);
        }
    }
}

