/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.recipes.machine.PressureChamberRecipeImpl;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class PressureEnchantingRecipe
extends PressureChamberRecipeImpl {
    public static final ResourceLocation ID = PneumaticRegistry.RL("pressure_chamber_enchanting");

    public PressureEnchantingRecipe(CraftingBookCategory category) {
        super(Collections.emptyList(), 2.0f, List.of());
    }

    @Override
    public IntCollection findIngredients(@Nonnull IItemHandler chamberHandler) {
        ItemStack stack;
        int i;
        IntArrayList bookSlots = new IntArrayList();
        for (i = 0; i < chamberHandler.getSlots(); ++i) {
            stack = chamberHandler.getStackInSlot(i);
            if (stack.getItem() != Items.ENCHANTED_BOOK) continue;
            bookSlots.add(i);
        }
        for (i = 0; i < chamberHandler.getSlots(); ++i) {
            stack = chamberHandler.getStackInSlot(i);
            if (!stack.isEnchantable() && !stack.isEnchanted()) continue;
            IntListIterator intListIterator = bookSlots.iterator();
            while (intListIterator.hasNext()) {
                int bookSlot = (Integer)intListIterator.next();
                ItemStack enchantedBook = chamberHandler.getStackInSlot(bookSlot);
                if (!this.isApplicable(enchantedBook, stack)) continue;
                return IntList.of((int)bookSlot, (int)i);
            }
        }
        return IntList.of();
    }

    private boolean isApplicable(ItemStack enchantedBook, ItemStack enchantable) {
        Map bookMap = EnchantmentHelper.getEnchantments((ItemStack)enchantedBook);
        return bookMap.entrySet().stream().anyMatch(entry -> enchantable.canApplyAtEnchantingTable((Enchantment)entry.getKey()) && enchantable.getEnchantmentLevel((Enchantment)entry.getKey()) < (Integer)entry.getValue());
    }

    public NonNullList<ItemStack> craftRecipe(@Nonnull IItemHandler chamberHandler, IntList ingredientSlots, boolean simulate) {
        ItemStack newBook;
        ItemStack enchantedBook = chamberHandler.getStackInSlot(ingredientSlots.getInt(0));
        ItemStack enchantable = ItemHandlerHelper.copyStackWithSize((ItemStack)chamberHandler.getStackInSlot(ingredientSlots.getInt(1)), (int)1);
        Map bookEnchantments = EnchantmentHelper.getEnchantments((ItemStack)enchantedBook);
        Set itemEnchantments = EnchantmentHelper.getEnchantments((ItemStack)enchantable).keySet();
        ArrayList toTransfer = new ArrayList();
        bookEnchantments.forEach((enchantment, level) -> {
            if (enchantment.canEnchant(enchantable) && itemEnchantments.stream().allMatch(e -> e.isCompatibleWith(enchantment))) {
                enchantable.enchant(enchantment, level.intValue());
                toTransfer.add(enchantment);
            }
        });
        if (toTransfer.isEmpty()) {
            return NonNullList.create();
        }
        toTransfer.forEach(bookEnchantments::remove);
        if (bookEnchantments.isEmpty()) {
            newBook = new ItemStack((ItemLike)Items.BOOK);
        } else {
            newBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            bookEnchantments.forEach((arg_0, arg_1) -> ((ItemStack)newBook).enchant(arg_0, arg_1));
        }
        chamberHandler.extractItem(ingredientSlots.getInt(0), 1, simulate);
        chamberHandler.extractItem(ingredientSlots.getInt(1), 1, simulate);
        return NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{newBook, enchantable});
    }

    @Override
    public List<Ingredient> getInputsForDisplay() {
        ItemStack enchBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        enchBook.enchant(Enchantments.BLOCK_FORTUNE, 1);
        return ImmutableList.of((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND_PICKAXE}), (Object)Ingredient.of((ItemStack[])new ItemStack[]{enchBook}));
    }

    @Override
    public List<ItemStack> getSingleResultsForDisplay() {
        ItemStack pick = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        pick.enchant(Enchantments.BLOCK_FORTUNE, 1);
        ItemStack book = new ItemStack((ItemLike)Items.BOOK);
        return NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{pick, book});
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        return stack.getItem() == Items.ENCHANTED_BOOK || stack.isEnchantable();
    }

    @Override
    public String getTooltipKey(boolean input, String slotName) {
        return switch (slotName) {
            case "in0" -> "pneumaticcraft.gui.nei.tooltip.pressureEnchantItem";
            case "in1" -> "pneumaticcraft.gui.nei.tooltip.pressureEnchantBook";
            case "out0" -> "pneumaticcraft.gui.nei.tooltip.pressureEnchantItemOut";
            case "out1" -> "pneumaticcraft.gui.nei.tooltip.pressureEnchantBookOut";
            default -> "";
        };
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.PRESSURE_CHAMBER_ENCHANTING.get();
    }
}

