/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.RefineryRecipe;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.util.CodecUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.Validate;

public class RefineryRecipeImpl
extends RefineryRecipe {
    public final FluidIngredient input;
    public final List<FluidStack> outputs;
    private final TemperatureRange operatingTemp;

    public RefineryRecipeImpl(FluidIngredient input, TemperatureRange operatingTemp, List<FluidStack> outputs) {
        this.operatingTemp = operatingTemp;
        Validate.isTrue((outputs.size() >= 2 && outputs.size() <= 4 ? 1 : 0) != 0, (String)"Recipe must have between 2 and 4 (inclusive) outputs", (Object[])new Object[0]);
        this.input = input;
        this.outputs = ImmutableList.copyOf(outputs);
    }

    @Override
    public FluidIngredient getInput() {
        return this.input;
    }

    @Override
    public List<FluidStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public TemperatureRange getOperatingTemp() {
        return this.operatingTemp;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.REFINERY.get();
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.REFINERY.get();
    }

    public String getGroup() {
        return "pneumaticcraft:refinery";
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.REFINERY.get());
    }

    public static class Serializer<T extends RefineryRecipe>
    implements RecipeSerializer<T> {
        private final Codec<T> codec;
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.create(builder -> builder.group((App)FluidIngredient.FLUID_CODEC_NON_EMPTY.fieldOf("input").forGetter(RefineryRecipe::getInput), (App)TemperatureRange.CODEC.optionalFieldOf("temperature", (Object)TemperatureRange.min(373)).forGetter(RefineryRecipe::getOperatingTemp), (App)CodecUtil.listWithSizeBound(FluidStack.CODEC.listOf(), 2, 4).fieldOf("outputs").forGetter(RefineryRecipe::getOutputs)).apply((Applicative)builder, factory::create));
        }

        public Codec<T> codec() {
            return this.codec;
        }

        public T fromNetwork(FriendlyByteBuf buffer) {
            FluidIngredient input = FluidIngredient.fluidFromNetwork(buffer);
            TemperatureRange range = TemperatureRange.read(buffer);
            List outputs = buffer.readList(FluidStack::readFromPacket);
            return this.factory.create(input, range, outputs);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((RefineryRecipe)recipe).getInput().fluidToNetwork(buffer);
            ((RefineryRecipe)recipe).getOperatingTemp().write(buffer);
            buffer.writeCollection(((RefineryRecipe)recipe).getOutputs(), (buf, fluidStack) -> fluidStack.writeToPacket(buf));
        }

        public static interface IFactory<T extends RefineryRecipe> {
            public T create(FluidIngredient var1, TemperatureRange var2, List<FluidStack> var3);
        }
    }
}

