/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class ThermoPlantRecipeImpl
extends ThermoPlantRecipe {
    private final Optional<FluidIngredient> inputFluid;
    private final FluidStack outputFluid;
    private final Optional<Ingredient> inputItem;
    private final float requiredPressure;
    private final float recipeSpeed;
    private final boolean exothermic;
    private final TemperatureRange operatingTemperature;
    private final ItemStack outputItem;
    private final float airUseMultiplier;

    public ThermoPlantRecipeImpl(Optional<FluidIngredient> inputFluid, Optional<Ingredient> inputItem, FluidStack outputFluid, ItemStack outputItem, TemperatureRange operatingTemperature, float requiredPressure, float recipeSpeed, float airUseMultiplier, boolean exothermic) {
        this.inputItem = inputItem;
        this.inputFluid = inputFluid;
        this.outputFluid = outputFluid;
        this.outputItem = outputItem;
        this.operatingTemperature = operatingTemperature;
        this.requiredPressure = requiredPressure;
        this.recipeSpeed = recipeSpeed;
        this.airUseMultiplier = airUseMultiplier;
        this.exothermic = exothermic;
    }

    @Override
    public boolean matches(FluidStack fluidStack, @Nonnull ItemStack itemStack) {
        boolean itemOK = this.inputItem.map(ingr -> ingr.test(itemStack)).orElse(itemStack.isEmpty());
        boolean fluidOK = this.inputFluid.map(ingr -> ingr.testFluid(fluidStack.getFluid())).orElse(fluidStack.isEmpty());
        return itemOK && fluidOK;
    }

    @Override
    public TemperatureRange getOperatingTemperature() {
        return this.operatingTemperature;
    }

    @Override
    public float getRequiredPressure() {
        return this.requiredPressure;
    }

    @Override
    public Optional<FluidIngredient> getInputFluid() {
        return this.inputFluid;
    }

    @Override
    @Nonnull
    public Optional<Ingredient> getInputItem() {
        return this.inputItem;
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    @Override
    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    @Override
    public boolean isExothermic() {
        return this.exothermic;
    }

    @Override
    public float getRecipeSpeed() {
        return this.recipeSpeed;
    }

    @Override
    public float getAirUseMultiplier() {
        return this.airUseMultiplier;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.THERMO_PLANT.get();
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.THERMO_PLANT.get();
    }

    public String getGroup() {
        return "pneumaticcraft:thermo_plant";
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get());
    }

    public static class Serializer<T extends ThermoPlantRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;
        private final Codec<T> codec;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
            this.codec = ExtraCodecs.validate((Codec)RecordCodecBuilder.create(inst -> inst.group((App)FluidIngredient.FLUID_CODEC.optionalFieldOf("fluid_input").forGetter(ThermoPlantRecipe::getInputFluid), (App)Ingredient.CODEC.optionalFieldOf("item_input").forGetter(ThermoPlantRecipe::getInputItem), (App)FluidStack.CODEC.optionalFieldOf("fluid_output", (Object)FluidStack.EMPTY).forGetter(ThermoPlantRecipe::getOutputFluid), (App)ItemStack.ITEM_WITH_COUNT_CODEC.optionalFieldOf("item_output", (Object)ItemStack.EMPTY).forGetter(ThermoPlantRecipe::getOutputItem), (App)TemperatureRange.CODEC.optionalFieldOf("temperature", (Object)TemperatureRange.any()).forGetter(ThermoPlantRecipe::getOperatingTemperature), (App)Codec.FLOAT.optionalFieldOf("pressure", (Object)Float.valueOf(0.0f)).forGetter(ThermoPlantRecipe::getRequiredPressure), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(1.0f)).forGetter(ThermoPlantRecipe::getRecipeSpeed), (App)Codec.FLOAT.optionalFieldOf("air_use_multiplier", (Object)Float.valueOf(1.0f)).forGetter(ThermoPlantRecipe::getAirUseMultiplier), (App)Codec.BOOL.optionalFieldOf("exothermic", (Object)false).forGetter(ThermoPlantRecipe::isExothermic)).apply((Applicative)inst, factory::create)), recipe -> recipe.getInputItem().isPresent() || recipe.getInputFluid().isPresent() ? DataResult.success((Object)recipe) : DataResult.error(() -> "at least one of item_input or fluid_input must be present!", (Object)recipe));
        }

        public Codec<T> codec() {
            return this.codec;
        }

        public T fromNetwork(FriendlyByteBuf buffer) {
            TemperatureRange range = TemperatureRange.read(buffer);
            float pressure = buffer.readFloat();
            Optional input = buffer.readOptional(Ingredient::fromNetwork);
            Optional fluidIn = buffer.readOptional(FluidIngredient::fluidFromNetwork);
            ItemStack itemOutput = buffer.readItem();
            FluidStack fluidOut = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            float recipeSpeed = buffer.readFloat();
            float airUseMultiplier = buffer.readFloat();
            boolean exothermic = buffer.readBoolean();
            return this.factory.create(fluidIn, input, fluidOut, itemOutput, range, pressure, recipeSpeed, airUseMultiplier, exothermic);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((ThermoPlantRecipe)recipe).getOperatingTemperature().write(buffer);
            buffer.writeFloat(((ThermoPlantRecipe)recipe).getRequiredPressure());
            buffer.writeOptional(((ThermoPlantRecipe)recipe).getInputItem(), (b, ingredient) -> ingredient.toNetwork(b));
            buffer.writeOptional(((ThermoPlantRecipe)recipe).getInputFluid(), (b, ingredient) -> ingredient.fluidToNetwork((FriendlyByteBuf)b));
            buffer.writeItem(((ThermoPlantRecipe)recipe).getOutputItem());
            ((ThermoPlantRecipe)recipe).getOutputFluid().writeToPacket(buffer);
            buffer.writeFloat(((ThermoPlantRecipe)recipe).getRecipeSpeed());
            buffer.writeFloat(((ThermoPlantRecipe)recipe).getAirUseMultiplier());
            buffer.writeBoolean(((ThermoPlantRecipe)recipe).isExothermic());
        }

        public static interface IFactory<T extends ThermoPlantRecipe> {
            public T create(Optional<FluidIngredient> var1, Optional<Ingredient> var2, FluidStack var3, ItemStack var4, TemperatureRange var5, float var6, float var7, float var8, boolean var9);
        }
    }
}

