/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.other;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.FuelQualityRecipe;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;

public class FuelQualityRecipeImpl
extends FuelQualityRecipe {
    private final FluidIngredient fuel;
    private final int airPerBucket;
    private final float burnRate;

    public FuelQualityRecipeImpl(FluidIngredient fuel, int airPerBucket, float burnRate) {
        this.fuel = fuel;
        this.airPerBucket = airPerBucket;
        this.burnRate = burnRate;
    }

    @Override
    public boolean matchesFluid(Fluid inputFluid) {
        return this.fuel.testFluid(inputFluid);
    }

    @Override
    public FluidIngredient getFuel() {
        return this.fuel;
    }

    @Override
    public int getAirPerBucket() {
        return this.airPerBucket;
    }

    @Override
    public float getBurnRate() {
        return this.burnRate;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.FUEL_QUALITY.get();
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.FUEL_QUALITY.get();
    }

    public static class Serializer<T extends FuelQualityRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;
        private final Codec<T> codec;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.create(builder -> builder.group((App)FluidIngredient.FLUID_CODEC_NON_EMPTY.fieldOf("fluid").forGetter(FuelQualityRecipe::getFuel), (App)ExtraCodecs.POSITIVE_INT.fieldOf("air_per_bucket").forGetter(FuelQualityRecipe::getAirPerBucket), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("burn_rate", (Object)Float.valueOf(1.0f)).forGetter(FuelQualityRecipe::getBurnRate)).apply((Applicative)builder, factory::create));
        }

        public Codec<T> codec() {
            return this.codec;
        }

        public T fromNetwork(FriendlyByteBuf buffer) {
            FluidIngredient fluidIn = FluidIngredient.fluidFromNetwork(buffer);
            int airPerBucket = buffer.readInt();
            float burnRate = buffer.readFloat();
            return this.factory.create(fluidIn, airPerBucket, burnRate);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((FuelQualityRecipe)recipe).getFuel().fluidToNetwork(buffer);
            buffer.writeInt(((FuelQualityRecipe)recipe).getAirPerBucket());
            buffer.writeFloat(((FuelQualityRecipe)recipe).getBurnRate());
        }

        public static interface IFactory<T extends FuelQualityRecipe> {
            public T create(FluidIngredient var1, int var2, float var3);
        }
    }
}

