/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.other;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicConstant;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HeatPropertiesRecipeImpl
extends HeatPropertiesRecipe {
    private final Block block;
    private final BlockState inputState;
    private final Optional<BlockState> transformHot;
    private final Optional<BlockState> transformHotFlowing;
    private final Optional<BlockState> transformCold;
    private final Optional<BlockState> transformColdFlowing;
    private final Map<String, String> predicates;
    private final Optional<Integer> heatCapacity;
    private final int temperature;
    private final Optional<Double> thermalResistance;
    private final String descriptionKey;
    private final HeatExchangerLogicConstant logic;

    public HeatPropertiesRecipeImpl(Block block, Optional<BlockState> transformHot, Optional<BlockState> transformHotFlowing, Optional<BlockState> transformCold, Optional<BlockState> transformColdFlowing, Optional<Integer> heatCapacity, int temperature, Optional<Double> thermalResistance, Map<String, String> predicates, String descriptionKey) {
        this.block = block;
        this.transformHot = transformHot;
        this.transformHotFlowing = transformHotFlowing;
        this.transformCold = transformCold;
        this.transformColdFlowing = transformColdFlowing;
        this.predicates = ImmutableMap.copyOf(predicates);
        this.heatCapacity = heatCapacity;
        this.temperature = temperature;
        this.thermalResistance = thermalResistance;
        this.descriptionKey = descriptionKey;
        this.logic = new HeatExchangerLogicConstant(temperature, thermalResistance.orElse(0.0));
        this.inputState = this.makeInputState();
    }

    private BlockState makeInputState() {
        if (!this.predicates.isEmpty()) {
            List<String> l = this.predicates.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toList();
            try {
                String regName = PneumaticCraftUtils.getRegistryName(this.block).orElseThrow().toString();
                String str = regName + "[" + String.join((CharSequence)",", l) + "]";
                BlockStateParser.BlockResult res = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)str, (boolean)false);
                return res.blockState();
            }
            catch (CommandSyntaxException e2) {
                return this.block.defaultBlockState();
            }
        }
        return this.block.defaultBlockState();
    }

    @Override
    public Optional<Integer> getHeatCapacity() {
        return this.heatCapacity;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public Optional<Double> getThermalResistance() {
        return this.thermalResistance;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockState getBlockState() {
        return this.inputState;
    }

    @Override
    public Optional<BlockState> getTransformHot() {
        return this.transformHot;
    }

    @Override
    public Optional<BlockState> getTransformCold() {
        return this.transformCold;
    }

    @Override
    public Optional<BlockState> getTransformHotFlowing() {
        return this.transformHotFlowing;
    }

    @Override
    public Optional<BlockState> getTransformColdFlowing() {
        return this.transformColdFlowing;
    }

    @Override
    public IHeatExchangerLogic getLogic() {
        return this.logic;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.HEAT_PROPERTIES.get();
    }

    public RecipeType<?> getType() {
        return ModRecipeTypes.BLOCK_HEAT_PROPERTIES.get();
    }

    @Override
    public boolean matchState(BlockState state) {
        if (this.predicates.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, String> entry : this.predicates.entrySet()) {
            Property iproperty = state.getBlock().getStateDefinition().getProperty(entry.getKey());
            if (iproperty == null) {
                return false;
            }
            Comparable comparable = iproperty.getValue(entry.getValue()).orElse(null);
            if (comparable != null && state.getValue(iproperty) == comparable) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, String> getBlockStatePredicates() {
        return this.predicates;
    }

    @Override
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public static class Serializer<T extends HeatPropertiesRecipe>
    implements RecipeSerializer<T> {
        private static final Codec<Map<String, String>> PREDICATES = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING);
        private static final Codec<BlockState> BLOCKSTATE_STRING = Codec.STRING.comapFlatMap(str -> {
            try {
                BlockStateParser.BlockResult result = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)str, (boolean)false);
                return DataResult.success((Object)result.blockState());
            }
            catch (CommandSyntaxException e) {
                return DataResult.error(() -> "can't parse blockstate " + str + ": " + e.getMessage());
            }
        }, BlockStateParser::serialize);
        private final IFactory<T> factory;
        private final Codec<T> codec;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.create(builder -> builder.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(HeatPropertiesRecipe::getBlock), (App)BLOCKSTATE_STRING.optionalFieldOf("transformHot").forGetter(HeatPropertiesRecipe::getTransformHot), (App)BLOCKSTATE_STRING.optionalFieldOf("transformHotFlowing").forGetter(HeatPropertiesRecipe::getTransformHotFlowing), (App)BLOCKSTATE_STRING.optionalFieldOf("transformCold").forGetter(HeatPropertiesRecipe::getTransformCold), (App)BLOCKSTATE_STRING.optionalFieldOf("transformColdFlowing").forGetter(HeatPropertiesRecipe::getTransformColdFlowing), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("heatCapacity").forGetter(HeatPropertiesRecipe::getHeatCapacity), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("temperature", (Object)0).forGetter(HeatPropertiesRecipe::getTemperature), (App)Codec.DOUBLE.optionalFieldOf("thermalResistance").forGetter(HeatPropertiesRecipe::getThermalResistance), (App)PREDICATES.optionalFieldOf("predicates", Map.of()).forGetter(HeatPropertiesRecipe::getBlockStatePredicates), (App)Codec.STRING.optionalFieldOf("description", (Object)"").forGetter(HeatPropertiesRecipe::getDescriptionKey)).apply((Applicative)builder, factory::create));
        }

        public Codec<T> codec() {
            return this.codec;
        }

        public T fromNetwork(FriendlyByteBuf buffer) {
            Block block = (Block)buffer.readById((IdMap)BuiltInRegistries.BLOCK);
            Optional<BlockState> transformHot = PacketUtil.readOptionalBlockState(buffer);
            Optional<BlockState> transformCold = PacketUtil.readOptionalBlockState(buffer);
            Optional<BlockState> transformHotFlowing = PacketUtil.readOptionalBlockState(buffer);
            Optional<BlockState> transformColdFlowing = PacketUtil.readOptionalBlockState(buffer);
            Map predicates = buffer.readMap(FriendlyByteBuf::readUtf, FriendlyByteBuf::readUtf);
            int temperature = buffer.readInt();
            Optional heatCapacity = buffer.readOptional(FriendlyByteBuf::readInt);
            Optional thermalResistance = buffer.readOptional(FriendlyByteBuf::readDouble);
            String descriptionKey = buffer.readUtf();
            return this.factory.create(block, transformHot, transformHotFlowing, transformCold, transformColdFlowing, heatCapacity, temperature, thermalResistance, predicates, descriptionKey);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            buffer.writeId((IdMap)BuiltInRegistries.BLOCK, (Object)((HeatPropertiesRecipe)recipe).getBlock());
            PacketUtil.writeOptionalBlockState(buffer, ((HeatPropertiesRecipe)recipe).getTransformHot());
            PacketUtil.writeOptionalBlockState(buffer, ((HeatPropertiesRecipe)recipe).getTransformCold());
            PacketUtil.writeOptionalBlockState(buffer, ((HeatPropertiesRecipe)recipe).getTransformHotFlowing());
            PacketUtil.writeOptionalBlockState(buffer, ((HeatPropertiesRecipe)recipe).getTransformColdFlowing());
            buffer.writeMap(((HeatPropertiesRecipe)recipe).getBlockStatePredicates(), FriendlyByteBuf::writeUtf, FriendlyByteBuf::writeUtf);
            buffer.writeInt(((HeatPropertiesRecipe)recipe).getTemperature());
            buffer.writeOptional(((HeatPropertiesRecipe)recipe).getHeatCapacity(), FriendlyByteBuf::writeInt);
            buffer.writeOptional(((HeatPropertiesRecipe)recipe).getThermalResistance(), FriendlyByteBuf::writeDouble);
            buffer.writeUtf(((HeatPropertiesRecipe)recipe).getDescriptionKey());
        }

        public static interface IFactory<T extends HeatPropertiesRecipe> {
            public T create(Block var1, Optional<BlockState> var2, Optional<BlockState> var3, Optional<BlockState> var4, Optional<BlockState> var5, Optional<Integer> var6, int var7, Optional<Double> var8, Map<String, String> var9, String var10);
        }
    }
}

