/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.special;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.recipes.special.WrappedShapedRecipe;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;
import org.jline.utils.Log;

public class CompressorUpgradeCrafting
extends WrappedShapedRecipe {
    private static final Supplier<List<Item>> COMPRESSORS = Suppliers.memoize(() -> List.of(CompressorUpgradeCrafting.getItem("advanced_air_compressor"), CompressorUpgradeCrafting.getItem("advanced_liquid_compressor"), CompressorUpgradeCrafting.getItem("air_compressor"), CompressorUpgradeCrafting.getItem("liquid_compressor")));

    public CompressorUpgradeCrafting(ShapedRecipe wrapped) {
        super(wrapped);
    }

    private static Item getItem(String id) {
        return (Item)BuiltInRegistries.ITEM.get(PneumaticRegistry.RL(id));
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.COMPRESSOR_UPGRADE_CRAFTING.get();
    }

    @NotNull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack result = this.wrapped.assemble(inv, registryAccess);
        int index = this.getMainItem(inv);
        if (index == -1) {
            Log.warn((Object[])new Object[]{"Just crafted a PNC Compressor upgrade recipe but couldn't find a compressor in the input!"});
            return ItemStack.EMPTY;
        }
        ItemStack input = inv.getItem(index);
        CompoundTag tag = input.getTag();
        if (tag == null) {
            return result;
        }
        Tag blockEntityTag = tag.get("BlockEntityTag");
        if (blockEntityTag == null) {
            return result;
        }
        result.getOrCreateTag().put("BlockEntityTag", blockEntityTag);
        return result;
    }

    private int getMainItem(CraftingContainer container) {
        int i;
        boolean matchFound = false;
        for (i = 0; i < container.getContainerSize(); ++i) {
            ItemStack item = container.getItem(i);
            if (!COMPRESSORS.get().contains(item.getItem())) continue;
            matchFound = true;
            break;
        }
        if (!matchFound) {
            return -1;
        }
        return i;
    }

    public static class Serializer
    implements RecipeSerializer<CompressorUpgradeCrafting> {
        public static final Codec<CompressorUpgradeCrafting> CODEC = ShapedRecipe.Serializer.CODEC.xmap(CompressorUpgradeCrafting::new, WrappedShapedRecipe::getWrapped);

        public Codec<CompressorUpgradeCrafting> codec() {
            return CODEC;
        }

        public CompressorUpgradeCrafting fromNetwork(FriendlyByteBuf buf) {
            return new CompressorUpgradeCrafting((ShapedRecipe)RecipeSerializer.SHAPED_RECIPE.fromNetwork(buf));
        }

        public void toNetwork(FriendlyByteBuf buf, CompressorUpgradeCrafting recipe) {
            RecipeSerializer.SHAPED_RECIPE.toNetwork(buf, (Recipe)recipe.wrapped);
        }
    }
}

