/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.special;

import java.util.List;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.common.item.DroneItem;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;

public class DroneColorCrafting
extends ShapelessRecipe {
    private static final List<Predicate<ItemStack>> ITEM_PREDICATES = List.of(stack -> stack.getItem() instanceof DroneItem, stack -> DyeColor.getColor((ItemStack)stack) != null);

    public DroneColorCrafting(CraftingBookCategory category) {
        super("", category, new ItemStack((ItemLike)ModItems.DRONE.get()), NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((TagKey)Tags.Items.DYES), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DRONE.get()})}));
    }

    public boolean matches(CraftingContainer container, Level level) {
        return ModCraftingHelper.allPresent(container, ITEM_PREDICATES);
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        List<ItemStack> stacks = ModCraftingHelper.findItems(container, ITEM_PREDICATES);
        ItemStack drone = stacks.get(0).copy();
        DyeColor dyeColor = DyeColor.getColor((ItemStack)stacks.get(1));
        if (drone.isEmpty() || dyeColor == null) {
            return ItemStack.EMPTY;
        }
        CompoundTag droneTag = drone.getOrCreateTag();
        droneTag.putInt("color", dyeColor.getId());
        return drone;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return w * h >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.DRONE_COLOR_CRAFTING.get();
    }
}

