/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.special;

import java.util.List;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.item.DroneItem;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DroneUpgradeCrafting
extends ShapelessRecipe {
    public static final List<Predicate<ItemStack>> ITEM_PREDICATES = List.of(DroneUpgradeCrafting::isBasicDrone, stack -> stack.getItem() == ModItems.PRINTED_CIRCUIT_BOARD.get());

    public DroneUpgradeCrafting(CraftingBookCategory category) {
        super("", category, new ItemStack((ItemLike)ModItems.DRONE.get()), NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PRINTED_CIRCUIT_BOARD.get()}), Ingredient.of(PneumaticCraftTags.Items.BASIC_DRONES)}));
    }

    public boolean matches(CraftingContainer container, Level level) {
        return ModCraftingHelper.allPresent(container, ITEM_PREDICATES);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        List<ItemStack> items = ModCraftingHelper.findItems(inv, ITEM_PREDICATES);
        if (items.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack drone = new ItemStack((ItemLike)ModItems.DRONE.get());
        CompoundTag droneTag = items.get(0).getOrCreateTag();
        drone.setTag(droneTag);
        return drone;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return w * h >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.DRONE_UPGRADE_CRAFTING.get();
    }

    private static boolean isBasicDrone(ItemStack stack) {
        DroneItem d;
        Item item = stack.getItem();
        return item instanceof DroneItem && !(d = (DroneItem)item).canProgram(stack);
    }
}

