/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.special;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.item.minigun.StandardGunAmmoItem;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GunAmmoPotionCrafting
extends ShapelessRecipe {
    private static final List<Predicate<ItemStack>> ITEM_PREDICATES = List.of(stack -> stack.getItem() instanceof PotionItem, stack -> stack.getItem() instanceof StandardGunAmmoItem);

    public GunAmmoPotionCrafting(CraftingBookCategory category) {
        super("", category, ((StandardGunAmmoItem)((Object)ModItems.GUN_AMMO.get())).getDefaultInstance(), NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.GUN_AMMO.get()}), new PotionIngredient()}));
    }

    public boolean matches(CraftingContainer container, Level level) {
        return ModCraftingHelper.allPresent(container, ITEM_PREDICATES);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        List<ItemStack> stacks = ModCraftingHelper.findItems(inv, ITEM_PREDICATES);
        if (stacks.size() == 2) {
            ItemStack potion = stacks.get(0);
            ItemStack ammo = stacks.get(1).copy();
            if (!ammo.isEmpty() && !potion.isEmpty()) {
                StandardGunAmmoItem.setPotion(ammo, potion);
                return ammo;
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return w * h >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.GUN_AMMO_POTION_CRAFTING.get();
    }

    private static class PotionIngredient
    extends Ingredient {
        PotionIngredient() {
            super(Stream.empty());
        }

        public ItemStack[] getItems() {
            NonNullList potions = NonNullList.create();
            for (Potion p : BuiltInRegistries.POTION) {
                if (p == Potions.EMPTY) continue;
                potions.add((Object)PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.POTION), (Potion)p));
            }
            return (ItemStack[])potions.toArray((Object[])new ItemStack[0]);
        }

        public boolean test(@Nullable ItemStack stack) {
            return stack != null && !PotionUtils.getMobEffects((ItemStack)stack).isEmpty();
        }
    }
}

