/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.special;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class OneProbeCrafting
extends ShapelessRecipe {
    private static final Supplier<Item> oneProbeItem = Suppliers.memoize(() -> (Item)BuiltInRegistries.ITEM.get(new ResourceLocation("theoneprobe:probe")));
    protected static final List<Predicate<ItemStack>> ITEM_PREDICATE = List.of(stack -> stack.getItem() == ModItems.PNEUMATIC_HELMET.get(), stack -> stack.getItem() == oneProbeItem.get() && !stack.isEmpty());
    private static final String ONE_PROBE_TAG = "theoneprobe";

    public OneProbeCrafting(CraftingBookCategory category) {
        super("", category, (ItemStack)Util.make((Object)new ItemStack((ItemLike)ModItems.PNEUMATIC_HELMET.get()), OneProbeCrafting::setOneProbeEnabled), NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PNEUMATIC_HELMET.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)oneProbeItem.get()})}));
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return ModCraftingHelper.allPresent(inv, ITEM_PREDICATE);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        List<ItemStack> stacks = ModCraftingHelper.findItems(inv, ITEM_PREDICATE);
        return OneProbeCrafting.setOneProbeEnabled(stacks.get(0).copy());
    }

    public boolean canCraftInDimensions(int w, int h) {
        return w * h >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.ONE_PROBE_HELMET_CRAFTING.get();
    }

    public static boolean isOneProbeEnabled(ItemStack helmetStack) {
        return helmetStack.hasTag() && helmetStack.getTag().getInt(ONE_PROBE_TAG) > 0;
    }

    private static ItemStack setOneProbeEnabled(ItemStack helmetStack) {
        helmetStack.getOrCreateTag().putInt(ONE_PROBE_TAG, 1);
        return helmetStack;
    }
}

