/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.special;

import com.mojang.serialization.Codec;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.recipes.special.WrappedShapedRecipe;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class ShapedPressurizableRecipe
extends WrappedShapedRecipe {
    public ShapedPressurizableRecipe(ShapedRecipe wrapped) {
        super(wrapped);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack newOutput = this.getResultItem(registryAccess).copy();
        IOHelper.getCap(newOutput, PNCCapabilities.AIR_HANDLER_ITEM).ifPresent(outputHandler -> {
            int totalAir = 0;
            for (int i = 0; i < inv.getContainerSize(); ++i) {
                ItemStack stack = inv.getItem(i);
                totalAir += IOHelper.getCap(stack, PNCCapabilities.AIR_HANDLER_ITEM).map(IAirHandler::getAir).orElse(0).intValue();
            }
            outputHandler.addAir(totalAir);
        });
        return newOutput;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.CRAFTING_SHAPED_PRESSURIZABLE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ShapedPressurizableRecipe> {
        public static final Codec<ShapedPressurizableRecipe> CODEC = ShapedRecipe.Serializer.CODEC.xmap(ShapedPressurizableRecipe::new, WrappedShapedRecipe::getWrapped);

        public Codec<ShapedPressurizableRecipe> codec() {
            return CODEC;
        }

        public ShapedPressurizableRecipe fromNetwork(FriendlyByteBuf buf) {
            return new ShapedPressurizableRecipe((ShapedRecipe)RecipeSerializer.SHAPED_RECIPE.fromNetwork(buf));
        }

        public void toNetwork(FriendlyByteBuf buf, ShapedPressurizableRecipe recipe) {
            RecipeSerializer.SHAPED_RECIPE.toNetwork(buf, (Recipe)recipe.wrapped);
        }
    }
}

