/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.registry;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.entity.RingEntity;
import me.desht.pneumaticcraft.common.entity.drone.AmadroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.CollectorDroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.GuardDroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.HarvestingDroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.LogisticsDroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.ProgrammableControllerEntity;
import me.desht.pneumaticcraft.common.entity.projectile.MicromissileEntity;
import me.desht.pneumaticcraft.common.entity.projectile.TumblingBlockEntity;
import me.desht.pneumaticcraft.common.entity.projectile.VortexEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.CropSupportEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.HeatFrameEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.LogisticsActiveProviderEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.LogisticsDefaultStorageEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.LogisticsPassiveProviderEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.LogisticsRequesterEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.LogisticsStorageEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.SpawnerAgitatorEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.TransferGadgetEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModEntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"pneumaticcraft");
    public static final Supplier<EntityType<DroneEntity>> DRONE = ModEntityTypes.register("drone", ModEntityTypes::drone);
    public static final Supplier<EntityType<LogisticsDroneEntity>> LOGISTICS_DRONE = ModEntityTypes.register("logistics_drone", ModEntityTypes::logisticsDrone);
    public static final Supplier<EntityType<HarvestingDroneEntity>> HARVESTING_DRONE = ModEntityTypes.register("harvesting_drone", ModEntityTypes::harvestingDrone);
    public static final Supplier<EntityType<GuardDroneEntity>> GUARD_DRONE = ModEntityTypes.register("guard_drone", ModEntityTypes::guardDrone);
    public static final Supplier<EntityType<CollectorDroneEntity>> COLLECTOR_DRONE = ModEntityTypes.register("collector_drone", ModEntityTypes::collectorDrone);
    public static final Supplier<EntityType<AmadroneEntity>> AMADRONE = ModEntityTypes.register("amadrone", ModEntityTypes::amadrone);
    public static final Supplier<EntityType<ProgrammableControllerEntity>> PROGRAMMABLE_CONTROLLER = ModEntityTypes.register("programmable_controller", ModEntityTypes::programmableController);
    public static final Supplier<EntityType<VortexEntity>> VORTEX = ModEntityTypes.register("vortex", ModEntityTypes::vortex);
    public static final Supplier<EntityType<MicromissileEntity>> MICROMISSILE = ModEntityTypes.register("micromissile", ModEntityTypes::micromissile);
    public static final Supplier<EntityType<TumblingBlockEntity>> TUMBLING_BLOCK = ModEntityTypes.register("tumbling_block", ModEntityTypes::tumblingBlock);
    public static final Supplier<EntityType<RingEntity>> RING = ModEntityTypes.register("ring", ModEntityTypes::ring);
    public static final Supplier<EntityType<CropSupportEntity>> CROP_SUPPORT = ModEntityTypes.register("crop_support", ModEntityTypes::cropSupport);
    public static final Supplier<EntityType<SpawnerAgitatorEntity>> SPAWNER_AGITATOR = ModEntityTypes.register("spawner_agitator", ModEntityTypes::spawnerAgitator);
    public static final Supplier<EntityType<HeatFrameEntity>> HEAT_FRAME = ModEntityTypes.register("heat_frame", ModEntityTypes::heatFrame);
    public static final Supplier<EntityType<TransferGadgetEntity>> TRANSFER_GADGET = ModEntityTypes.register("transfer_gadget", ModEntityTypes::transferGadget);
    public static final Supplier<EntityType<LogisticsActiveProviderEntity>> LOGISTICS_FRAME_ACTIVE_PROVIDER = ModEntityTypes.register("logistics_frame_active_provider", ModEntityTypes::activeProvider);
    public static final Supplier<EntityType<LogisticsPassiveProviderEntity>> LOGISTICS_FRAME_PASSIVE_PROVIDER = ModEntityTypes.register("logistics_frame_passive_provider", ModEntityTypes::passiveProvider);
    public static final Supplier<EntityType<LogisticsStorageEntity>> LOGISTICS_FRAME_STORAGE = ModEntityTypes.register("logistics_frame_storage", ModEntityTypes::storage);
    public static final Supplier<EntityType<LogisticsDefaultStorageEntity>> LOGISTICS_FRAME_DEFAULT_STORAGE = ModEntityTypes.register("logistics_frame_default_storage", ModEntityTypes::defaultStorage);
    public static final Supplier<EntityType<LogisticsRequesterEntity>> LOGISTICS_FRAME_REQUESTER = ModEntityTypes.register("logistics_frame_requester", ModEntityTypes::requester);

    private static <E extends Entity> Supplier<EntityType<E>> register(String name, Supplier<EntityType.Builder<E>> sup) {
        return ENTITY_TYPES.register(name, () -> ((EntityType.Builder)sup.get()).build(name));
    }

    private static EntityType.Builder<VortexEntity> vortex() {
        return EntityType.Builder.of(VortexEntity::new, (MobCategory)MobCategory.MISC).sized(1.5f, 1.5f).fireImmune().setTrackingRange(4).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<DroneEntity> drone() {
        return EntityType.Builder.of(DroneEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.7f, 0.35f).setTrackingRange(32).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<AmadroneEntity> amadrone() {
        return EntityType.Builder.of(AmadroneEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.7f, 0.35f).setTrackingRange(32).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<LogisticsDroneEntity> logisticsDrone() {
        return EntityType.Builder.of(LogisticsDroneEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.7f, 0.35f).setTrackingRange(32).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<HarvestingDroneEntity> harvestingDrone() {
        return EntityType.Builder.of(HarvestingDroneEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.7f, 0.35f).setTrackingRange(32).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<GuardDroneEntity> guardDrone() {
        return EntityType.Builder.of(GuardDroneEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.7f, 0.35f).setTrackingRange(32).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<CollectorDroneEntity> collectorDrone() {
        return EntityType.Builder.of(CollectorDroneEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.7f, 0.35f).setTrackingRange(32).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<ProgrammableControllerEntity> programmableController() {
        return EntityType.Builder.of(ProgrammableControllerEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.35f, 0.175f).setTrackingRange(32).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<MicromissileEntity> micromissile() {
        return EntityType.Builder.of(MicromissileEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).fireImmune().setTrackingRange(4).setUpdateInterval(20).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TumblingBlockEntity> tumblingBlock() {
        return EntityType.Builder.of(TumblingBlockEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).fireImmune().setTrackingRange(4).setUpdateInterval(20).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<RingEntity> ring() {
        return EntityType.Builder.of(RingEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).fireImmune().setTrackingRange(4).setUpdateInterval(20).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<CropSupportEntity> cropSupport() {
        return EntityType.Builder.of(CropSupportEntity::new, (MobCategory)MobCategory.MISC).sized(0.625f, 0.5625f).fireImmune().setTrackingRange(3).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<SpawnerAgitatorEntity> spawnerAgitator() {
        return EntityType.Builder.of(SpawnerAgitatorEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).fireImmune().setTrackingRange(3).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<HeatFrameEntity> heatFrame() {
        return EntityType.Builder.of(HeatFrameEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).fireImmune().setTrackingRange(3).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<TransferGadgetEntity> transferGadget() {
        return EntityType.Builder.of(TransferGadgetEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).fireImmune().setTrackingRange(3).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<LogisticsActiveProviderEntity> activeProvider() {
        return EntityType.Builder.of(LogisticsActiveProviderEntity::new, (MobCategory)MobCategory.MISC).sized(0.625f, 0.5625f).fireImmune().setTrackingRange(3).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<LogisticsPassiveProviderEntity> passiveProvider() {
        return EntityType.Builder.of(LogisticsPassiveProviderEntity::new, (MobCategory)MobCategory.MISC).sized(0.625f, 0.5625f).fireImmune().setTrackingRange(3).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<LogisticsStorageEntity> storage() {
        return EntityType.Builder.of(LogisticsStorageEntity::new, (MobCategory)MobCategory.MISC).sized(0.625f, 0.5625f).fireImmune().setTrackingRange(3).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<LogisticsDefaultStorageEntity> defaultStorage() {
        return EntityType.Builder.of(LogisticsDefaultStorageEntity::new, (MobCategory)MobCategory.MISC).sized(0.625f, 0.5625f).fireImmune().setTrackingRange(3).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<LogisticsRequesterEntity> requester() {
        return EntityType.Builder.of(LogisticsRequesterEntity::new, (MobCategory)MobCategory.MISC).sized(0.625f, 0.5625f).fireImmune().setTrackingRange(3).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false);
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Listener {
        @SubscribeEvent
        public static void registerGlobalAttributes(EntityAttributeCreationEvent event) {
            event.put(DRONE.get(), DroneEntity.prepareAttributes().build());
            event.put(AMADRONE.get(), DroneEntity.prepareAttributes().build());
            event.put(COLLECTOR_DRONE.get(), DroneEntity.prepareAttributes().build());
            event.put(GUARD_DRONE.get(), DroneEntity.prepareAttributes().build());
            event.put(HARVESTING_DRONE.get(), DroneEntity.prepareAttributes().build());
            event.put(LOGISTICS_DRONE.get(), DroneEntity.prepareAttributes().build());
            event.put(PROGRAMMABLE_CONTROLLER.get(), DroneEntity.prepareAttributes().build());
        }
    }
}

