/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.registry;

import java.util.function.Consumer;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.fluid.FluidBiodiesel;
import me.desht.pneumaticcraft.common.fluid.FluidDiesel;
import me.desht.pneumaticcraft.common.fluid.FluidEtchingAcid;
import me.desht.pneumaticcraft.common.fluid.FluidEthanol;
import me.desht.pneumaticcraft.common.fluid.FluidGasoline;
import me.desht.pneumaticcraft.common.fluid.FluidKerosene;
import me.desht.pneumaticcraft.common.fluid.FluidLPG;
import me.desht.pneumaticcraft.common.fluid.FluidLubricant;
import me.desht.pneumaticcraft.common.fluid.FluidMemoryEssence;
import me.desht.pneumaticcraft.common.fluid.FluidOil;
import me.desht.pneumaticcraft.common.fluid.FluidPlastic;
import me.desht.pneumaticcraft.common.fluid.FluidVegetableOil;
import me.desht.pneumaticcraft.common.fluid.FluidYeastCulture;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ModFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"pneumaticcraft");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"pneumaticcraft");
    public static final Supplier<FluidType> OIL_FLUID_TYPE = ModFluids.registerFluidType("oil", ModFluids.standardProps(800, 20000), FluidOil.RENDER_PROPS);
    public static final Supplier<FluidType> BIODIESEL_FLUID_TYPE = ModFluids.registerFluidType("biodiesel", ModFluids.standardProps(880, 4000), FluidBiodiesel.RENDER_PROPS);
    public static final Supplier<FluidType> DIESEL_FLUID_TYPE = ModFluids.registerFluidType("diesel", ModFluids.standardProps(880, 4000), FluidDiesel.RENDER_PROPS);
    public static final Supplier<FluidType> ETCHING_ACID_FLUID_TYPE = ModFluids.registerFluidType("etching_acid", ModFluids.standardProps(1500, 2000), FluidEtchingAcid.RENDER_PROPS);
    public static final Supplier<FluidType> ETHANOL_FLUID_TYPE = ModFluids.registerFluidType("ethanol", ModFluids.standardProps(789, 1200), FluidEthanol.RENDER_PROPS);
    public static final Supplier<FluidType> GASOLINE_FLUID_TYPE = ModFluids.registerFluidType("gasoline", ModFluids.standardProps(750, 500), FluidGasoline.RENDER_PROPS);
    public static final Supplier<FluidType> KEROSENE_FLUID_TYPE = ModFluids.registerFluidType("kerosene", ModFluids.standardProps(790, 2700), FluidKerosene.RENDER_PROPS);
    public static final Supplier<FluidType> LPG_FLUID_TYPE = ModFluids.registerFluidType("lpg", ModFluids.standardProps(550, 200), FluidLPG.RENDER_PROPS);
    public static final Supplier<FluidType> LUBRICANT_FLUID_TYPE = ModFluids.registerFluidType("lubricant", ModFluids.standardProps(800, 900), FluidLubricant.RENDER_PROPS);
    public static final Supplier<FluidType> MEMORY_ESSENCE_FLUID_TYPE = ModFluids.registerFluidType("memory_essence", ModFluids.standardProps(250, 250), FluidMemoryEssence.RENDER_PROPS);
    public static final Supplier<FluidType> PLASTIC_FLUID_TYPE = ModFluids.registerFluidType("plastic", ModFluids.standardProps(2000, 500).temperature(423), FluidPlastic.RENDER_PROPS);
    public static final Supplier<FluidType> VEGETABLE_OIL_FLUID_TYPE = ModFluids.registerFluidType("vegetable_oil", ModFluids.standardProps(900, 1500), FluidVegetableOil.RENDER_PROPS);
    public static final Supplier<FluidType> YEAST_CULTURE_FLUID_TYPE = ModFluids.registerFluidType("yeast_culture", ModFluids.standardProps(800, 5000), FluidYeastCulture.RENDER_PROPS);
    public static final Supplier<Fluid> OIL = ModFluids.register("oil", FluidOil.Source::new);
    public static final Supplier<Fluid> OIL_FLOWING = ModFluids.register("oil_flowing", FluidOil.Flowing::new);
    public static final Supplier<Fluid> ETCHING_ACID = ModFluids.register("etching_acid", FluidEtchingAcid.Source::new);
    public static final Supplier<Fluid> ETCHING_ACID_FLOWING = ModFluids.register("etching_acid_flowing", FluidEtchingAcid.Flowing::new);
    public static final Supplier<Fluid> PLASTIC = ModFluids.register("plastic", FluidPlastic.Source::new);
    public static final Supplier<Fluid> PLASTIC_FLOWING = ModFluids.register("plastic_flowing", FluidPlastic.Flowing::new);
    public static final Supplier<Fluid> DIESEL = ModFluids.register("diesel", FluidDiesel.Source::new);
    public static final Supplier<Fluid> DIESEL_FLOWING = ModFluids.register("diesel_flowing", FluidDiesel.Flowing::new);
    public static final Supplier<Fluid> KEROSENE = ModFluids.register("kerosene", FluidKerosene.Source::new);
    public static final Supplier<Fluid> KEROSENE_FLOWING = ModFluids.register("kerosene_flowing", FluidKerosene.Flowing::new);
    public static final Supplier<Fluid> GASOLINE = ModFluids.register("gasoline", FluidGasoline.Source::new);
    public static final Supplier<Fluid> GASOLINE_FLOWING = ModFluids.register("gasoline_flowing", FluidGasoline.Flowing::new);
    public static final Supplier<Fluid> LPG = ModFluids.register("lpg", FluidLPG.Source::new);
    public static final Supplier<Fluid> LPG_FLOWING = ModFluids.register("lpg_flowing", FluidLPG.Flowing::new);
    public static final Supplier<Fluid> LUBRICANT = ModFluids.register("lubricant", FluidLubricant.Source::new);
    public static final Supplier<Fluid> LUBRICANT_FLOWING = ModFluids.register("lubricant_flowing", FluidLubricant.Flowing::new);
    public static final Supplier<Fluid> MEMORY_ESSENCE = ModFluids.register("memory_essence", FluidMemoryEssence.Source::new);
    public static final Supplier<Fluid> MEMORY_ESSENCE_FLOWING = ModFluids.register("memory_essence_flowing", FluidMemoryEssence.Flowing::new);
    public static final Supplier<Fluid> YEAST_CULTURE = ModFluids.register("yeast_culture", FluidYeastCulture.Source::new);
    public static final Supplier<Fluid> YEAST_CULTURE_FLOWING = ModFluids.register("yeast_culture_flowing", FluidYeastCulture.Flowing::new);
    public static final Supplier<Fluid> ETHANOL = ModFluids.register("ethanol", FluidEthanol.Source::new);
    public static final Supplier<Fluid> ETHANOL_FLOWING = ModFluids.register("ethanol_flowing", FluidEthanol.Flowing::new);
    public static final Supplier<Fluid> VEGETABLE_OIL = ModFluids.register("vegetable_oil", FluidVegetableOil.Source::new);
    public static final Supplier<Fluid> VEGETABLE_OIL_FLOWING = ModFluids.register("vegetable_oil_flowing", FluidVegetableOil.Flowing::new);
    public static final Supplier<Fluid> BIODIESEL = ModFluids.register("biodiesel", FluidBiodiesel.Source::new);
    public static final Supplier<Fluid> BIODIESEL_FLOWING = ModFluids.register("biodiesel_flowing", FluidBiodiesel.Flowing::new);

    private static <T extends Fluid> Supplier<T> register(String name, Supplier<T> sup) {
        return FLUIDS.register(name, sup);
    }

    private static Supplier<FluidType> registerFluidType(String name, FluidType.Properties props, final IClientFluidTypeExtensions renderProps) {
        return FLUID_TYPES.register(name, () -> new FluidType(props){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(renderProps);
            }
        });
    }

    private static FluidType.Properties standardProps(int density, int viscosity) {
        return FluidType.Properties.create().density(density).viscosity(viscosity).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH);
    }
}

