/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.registry;

import java.util.function.Supplier;
import java.util.regex.Pattern;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.harvesting.HarvestHandler;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCactusLike;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCropLike;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCrops;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerLeaves;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerTree;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;

public class ModHarvestHandlers {
    public static final ResourceKey<Registry<HarvestHandler>> HARVEST_HANDLERS_KEY = ResourceKey.createRegistryKey((ResourceLocation)PneumaticRegistry.RL("harvest_handlers"));
    public static final Registry<HarvestHandler> HARVEST_HANDLER_REGISTRY = new RegistryBuilder(HARVEST_HANDLERS_KEY).create();
    public static final DeferredRegister<HarvestHandler> HARVEST_HANDLERS_DEFERRED = DeferredRegister.create(HARVEST_HANDLER_REGISTRY, (String)"pneumaticcraft");
    public static final Supplier<HarvestHandler> CROPS = ModHarvestHandlers.register("crops", HarvestHandlerCrops::new);
    public static final Supplier<HarvestHandler> NETHER_WART = ModHarvestHandlers.register("nether_wart", HarvestHandlerCropLike.NetherWart::new);
    public static final Supplier<HarvestHandler> SWEET_BERRIES = ModHarvestHandlers.register("sweet_berries", HarvestHandlerCropLike.SweetBerry::new);
    public static final Supplier<HarvestHandler> COCOA = ModHarvestHandlers.register("cocoa_beans", HarvestHandlerCropLike.Cocoa::new);
    public static final Supplier<HarvestHandler> CACTUS = ModHarvestHandlers.register("cactus_like", HarvestHandlerCactusLike.VanillaCrops::new);
    public static final Supplier<HarvestHandler> PUMPKIN = ModHarvestHandlers.register("pumpkin_like", () -> new HarvestHandler.SimpleHarvestHandler(Blocks.PUMPKIN, Blocks.MELON));
    public static final Supplier<HarvestHandler> LEAVES = ModHarvestHandlers.register("leaves", HarvestHandlerLeaves::new);
    public static final Supplier<HarvestHandler> TREES = ModHarvestHandlers.register("trees", HarvestHandlerTree::new);

    public static <T extends HarvestHandler> Supplier<T> register(String name, Supplier<T> sup) {
        return HARVEST_HANDLERS_DEFERRED.register(name, sup);
    }

    public static enum TreePart {
        LOG("_log"),
        LEAVES("_leaves"),
        SAPLING("_sapling");

        private final String suffix;
        private final Pattern pattern;

        private TreePart(String suffix) {
            this.suffix = suffix;
            this.pattern = Pattern.compile(suffix + "$");
        }

        public Block convert(Block in, TreePart to) {
            return PneumaticCraftUtils.getRegistryName(in).map(rlIn -> {
                ResourceLocation rlOut = new ResourceLocation(rlIn.getNamespace(), this.pattern.matcher(rlIn.getPath()).replaceAll(to.suffix));
                return (Block)BuiltInRegistries.BLOCK.get(rlOut);
            }).orElse(Blocks.AIR);
        }
    }
}

