/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.semiblock;

import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class SemiblockItem
extends Item {
    public SemiblockItem() {
        super(ModItems.defaultProps());
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        return this.placeSemiblock(context);
    }

    public AbstractSemiblockEntity createEntity(Level world, ItemStack stack, Player player, BlockPos pos) {
        ResourceLocation regName = PneumaticCraftUtils.getRegistryName(this).orElseThrow();
        return BuiltInRegistries.ENTITY_TYPE.getOptional(regName).map(type -> {
            Entity e = type.create(world);
            if (e instanceof AbstractSemiblockEntity) {
                AbstractSemiblockEntity semi = (AbstractSemiblockEntity)e;
                e.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                EntityType.updateCustomEntityTag((Level)world, (Player)player, (Entity)e, (CompoundTag)stack.getTag());
                return semi;
            }
            return null;
        }).orElse(null);
    }

    private InteractionResult placeSemiblock(UseOnContext context) {
        Level world = context.getLevel();
        ItemStack itemstack = context.getItemInHand();
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        Player player = context.getPlayer();
        AbstractSemiblockEntity eSemi = this.createEntity(context.getLevel(), itemstack, context.getPlayer(), blockpos);
        if (eSemi != null) {
            if (!eSemi.canPlace(direction)) {
                eSemi.setPos(eSemi.getX() + (double)direction.getStepX(), eSemi.getY() + (double)direction.getStepY(), eSemi.getZ() + (double)direction.getStepZ());
                if (!eSemi.canPlace(direction)) {
                    return InteractionResult.FAIL;
                }
            }
            if (eSemi instanceof IDirectionalSemiblock) {
                IDirectionalSemiblock d = (IDirectionalSemiblock)((Object)eSemi);
                d.setSide(direction);
            }
            if (SemiblockTracker.getInstance().getAllSemiblocks(world, eSemi.getBlockPos()).anyMatch(s -> !s.canCoexist(eSemi))) {
                return InteractionResult.FAIL;
            }
            world.addFreshEntity((Entity)eSemi);
            eSemi.onPlaced(player, context.getItemInHand(), direction);
            if (player != null && !player.isCreative()) {
                itemstack.shrink(1);
            }
        } else {
            Log.warning("can't get entity for semiblock item: " + this, new Object[0]);
        }
        return InteractionResult.SUCCESS;
    }
}

