/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.semiblock;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

@Mod.EventBusSubscriber(modid="pneumaticcraft")
public enum SemiblockTracker {
    INSTANCE;

    private static final Map<ResourceLocation, Map<BlockPos, SemiblockCollection>> semiblockMap;

    public static SemiblockTracker getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        if (!event.getServer().isDedicatedServer()) {
            semiblockMap.values().forEach(Map::clear);
            semiblockMap.clear();
        }
    }

    public ISemiBlock getSemiblock(Level world, BlockPos pos) {
        return this.getSemiblock(world, pos, null);
    }

    public ISemiBlock getSemiblock(Level world, BlockPos pos, Direction direction) {
        if (!world.isLoaded(pos)) {
            return null;
        }
        Map<BlockPos, SemiblockCollection> map = semiblockMap.get(this.getKey(world));
        if (map == null) {
            return null;
        }
        SemiblockCollection sc = map.get(pos);
        return sc == null ? null : sc.get(direction);
    }

    public Stream<ISemiBlock> getAllSemiblocks(Level world, BlockPos pos) {
        return this.getAllSemiblocks(world, pos, null);
    }

    public Stream<ISemiBlock> getAllSemiblocks(Level world, BlockPos pos, Direction offsetDir) {
        if (!world.isLoaded(pos)) {
            return Stream.empty();
        }
        Map map = semiblockMap.computeIfAbsent(this.getKey(world), k -> new HashMap());
        if (map.isEmpty()) {
            return Stream.empty();
        }
        SemiblockCollection sc = (SemiblockCollection)map.get(pos);
        if (sc == null && offsetDir != null) {
            sc = (SemiblockCollection)map.get(pos.relative(offsetDir));
        }
        return sc == null ? Stream.empty() : sc.getAll();
    }

    public void clearSemiblock(Level world, BlockPos pos, Direction direction) {
        Map map = semiblockMap.computeIfAbsent(this.getKey(world), k -> new HashMap());
        SemiblockCollection sc = (SemiblockCollection)map.get(pos);
        if (sc != null) {
            sc.clear(direction);
        }
    }

    public boolean putSemiblock(Level world, BlockPos pos, ISemiBlock entity) {
        Map map = semiblockMap.computeIfAbsent(this.getKey(world), k -> new HashMap());
        SemiblockCollection sc = (SemiblockCollection)map.get(pos);
        if (sc == null) {
            map.put(pos, new SemiblockCollection(entity));
            return true;
        }
        return sc.set(entity);
    }

    public Stream<ISemiBlock> getSemiblocksInArea(Level world, BoundingBox aabb) {
        Map map = semiblockMap.computeIfAbsent(this.getKey(world), k -> new HashMap());
        return map.entrySet().stream().filter(e -> this.boxContainsBlockPos(aabb, (BlockPos)e.getKey())).flatMap(e -> ((SemiblockCollection)e.getValue()).getAll());
    }

    private boolean boxContainsBlockPos(BoundingBox aabb, BlockPos pos) {
        return pos.getX() >= aabb.minX() && pos.getX() <= aabb.maxX() && pos.getY() >= aabb.minY() && pos.getY() <= aabb.maxY() && pos.getZ() >= aabb.minZ() && pos.getZ() <= aabb.maxZ();
    }

    private ResourceLocation getKey(Level world) {
        return world.dimension().location();
    }

    static {
        semiblockMap = new HashMap<ResourceLocation, Map<BlockPos, SemiblockCollection>>();
    }

    private static class SemiblockCollection {
        private WeakReference<ISemiBlock> center = new WeakReference<Object>(null);
        private final List<WeakReference<ISemiBlock>> sides = new ArrayList<WeakReference<ISemiBlock>>();

        SemiblockCollection(ISemiBlock e) {
            this.set(e);
        }

        public ISemiBlock get(Direction direction) {
            if (direction == null) {
                return (ISemiBlock)this.center.get();
            }
            return this.sides.isEmpty() ? null : (ISemiBlock)this.sides.get(direction.get3DDataValue()).get();
        }

        boolean set(ISemiBlock semiBlock) {
            Direction dir;
            Direction direction = dir = semiBlock instanceof IDirectionalSemiblock ? ((IDirectionalSemiblock)((Object)semiBlock)).getSide() : null;
            if (dir == null) {
                if (this.center.get() != null) {
                    return false;
                }
                this.center = new WeakReference<ISemiBlock>(semiBlock);
            } else {
                if (this.sides.isEmpty()) {
                    for (int i = 0; i < 6; ++i) {
                        this.sides.add(new WeakReference<Object>(null));
                    }
                }
                if (this.sides.get(dir.get3DDataValue()).get() != null) {
                    return false;
                }
                this.sides.set(dir.get3DDataValue(), new WeakReference<ISemiBlock>(semiBlock));
            }
            return true;
        }

        public void clear(Direction direction) {
            if (direction == null) {
                if (this.center != null) {
                    this.center.clear();
                }
            } else if (!this.sides.isEmpty()) {
                this.sides.get(direction.get3DDataValue()).clear();
            }
        }

        Stream<ISemiBlock> getAll() {
            Stream s1 = this.center.get() == null ? Stream.empty() : Stream.of((ISemiBlock)this.center.get());
            Stream<ISemiBlock> s2 = this.sides.stream().filter(ref -> ref.get() != null).map(Reference::get);
            return Stream.concat(s1, s2);
        }
    }
}

