/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.api.wrench.IWrenchRegistry;
import me.desht.pneumaticcraft.common.item.PneumaticWrenchItem;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;

public enum ModdedWrenchUtils implements IWrenchRegistry
{
    INSTANCE;

    private final Set<ResourceLocation> wrenches = new HashSet<ResourceLocation>();
    private static final BiFunction<UseOnContext, BlockState, InteractionResult> NO_OP_PRE;
    private static final BiConsumer<UseOnContext, BlockState> NO_OP_POST;
    private final Map<String, BiFunction<UseOnContext, BlockState, InteractionResult>> modBehavioursPre = new ConcurrentHashMap<String, BiFunction<UseOnContext, BlockState, InteractionResult>>();
    private final Map<String, BiConsumer<UseOnContext, BlockState>> modBehavioursPost = new ConcurrentHashMap<String, BiConsumer<UseOnContext, BlockState>>();

    public static ModdedWrenchUtils getInstance() {
        return INSTANCE;
    }

    void registerThirdPartyWrenches() {
        this.registerWrench("thermalfoundation:wrench");
        this.registerWrench("rftools:smartwrench");
        this.registerWrench("immersiveengineering:hammer");
        this.registerWrench("appliedenergistics2:certus_quartz_wrench");
        this.registerWrench("appliedenergistics2:nether_quartz_wrench");
        this.registerWrench("enderio:item_yeta_wrench");
        this.registerWrench("buildcraftcore:wrench");
        this.registerWrench("teslacorelib:wrench");
        this.registerWrench("ic2:wrench");
        this.registerWrench("chiselsandbits:wrench_wood");
        this.registerWrench("mekanism:configurator");
    }

    private void registerWrench(String wrenchId) {
        this.wrenches.add(new ResourceLocation(wrenchId));
    }

    @Override
    public boolean isModdedWrench(@Nonnull ItemStack stack) {
        return !(stack.getItem() instanceof PneumaticWrenchItem) && (stack.is(PneumaticCraftTags.Items.WRENCHES) || this.wrenches.contains(PneumaticCraftUtils.getRegistryName(stack.getItem()).orElseThrow()));
    }

    @Override
    public boolean isWrench(@Nonnull ItemStack stack) {
        return stack.getItem() instanceof PneumaticWrenchItem || this.isModdedWrench(stack);
    }

    @Override
    public void registerWrench(Item wrench) {
        this.wrenches.add(PneumaticCraftUtils.getRegistryName(wrench).orElseThrow());
    }

    @Override
    public void addModdedWrenchBehaviour(String modid, BiFunction<UseOnContext, BlockState, InteractionResult> behaviourPre, BiConsumer<UseOnContext, BlockState> behaviourPost) {
        this.modBehavioursPre.put(modid, behaviourPre);
        this.modBehavioursPost.put(modid, behaviourPost);
    }

    public InteractionResult onWrenchedPre(UseOnContext ctx, BlockState state) {
        return this.modBehavioursPre.getOrDefault(ModdedWrenchUtils.getModId(state), NO_OP_PRE).apply(ctx, state);
    }

    public void onWrenchedPost(UseOnContext ctx, BlockState state) {
        this.modBehavioursPost.getOrDefault(ModdedWrenchUtils.getModId(state), NO_OP_POST).accept(ctx, state);
    }

    private static String getModId(BlockState state) {
        return PneumaticCraftUtils.getRegistryName(state.getBlock()).orElseThrow().getNamespace();
    }

    static {
        NO_OP_PRE = (ctx, state) -> InteractionResult.PASS;
        NO_OP_POST = (ctx, state) -> {};
    }
}

