/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAmadronOffer;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class JEIAmadronTradeCategory
extends AbstractPNCCategory<AmadronRecipe> {
    private final IDrawable limitedIcon = JEIAmadronTradeCategory.guiHelper().drawableBuilder(Textures.GUI_OK_LOCATION, 0, 0, 16, 16).setTextureSize(16, 16).build();

    JEIAmadronTradeCategory() {
        super(RecipeTypes.AMADRON_TRADE, (Component)PneumaticCraftUtils.xlate(((AmadronTabletItem)ModItems.AMADRON_TABLET.get()).getDescriptionId(), new Object[0]), (IDrawable)JEIAmadronTradeCategory.guiHelper().createDrawable(Textures.WIDGET_AMADRON_OFFER, 0, 0, 73, 35), JEIAmadronTradeCategory.guiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.AMADRON_TABLET.get())));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AmadronRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 6, 15);
        recipe.getInput().accept(arg_0 -> ((IRecipeSlotBuilder)inputSlot).addItemStack(arg_0), fluidStack -> ((IRecipeSlotBuilder)inputSlot.addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, fluidStack)).setOverlay((IDrawable)new FluidTextOverlay((FluidStack)fluidStack), 0, 0));
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 51, 15);
        recipe.getOutput().accept(arg_0 -> ((IRecipeSlotBuilder)outputSlot).addItemStack(arg_0), fluidStack -> ((IRecipeSlotBuilder)outputSlot.addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, fluidStack)).setOverlay((IDrawable)new FluidTextOverlay((FluidStack)fluidStack), 0, 0));
    }

    public void draw(AmadronRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        Font fr = Minecraft.getInstance().font;
        int x = (this.getBackground().getWidth() - fr.width((FormattedText)recipe.getVendorName())) / 2;
        if (recipe.isLocationLimited()) {
            this.limitedIcon.draw(graphics, 60, -4);
        }
        graphics.drawString(fr, recipe.getVendorName(), x, 3, -12566464, false);
    }

    public List<Component> getTooltipStrings(AmadronRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> res = new ArrayList<Component>();
        if (recipe instanceof AmadronOffer) {
            AmadronOffer offer = (AmadronOffer)recipe;
            if (mouseX >= 22.0 && mouseX <= 51.0) {
                res.addAll(WidgetAmadronOffer.makeTooltip(offer, -1));
            }
        }
        return res;
    }

    private static class FluidTextOverlay
    implements IDrawable {
        private final String text;

        FluidTextOverlay(FluidStack stack) {
            this.text = stack.getAmount() / 1000 + "B";
        }

        public int getWidth() {
            return 16;
        }

        public int getHeight() {
            return 16;
        }

        public void draw(GuiGraphics graphics, int x, int y) {
            Font fr = Minecraft.getInstance().font;
            int n = x + this.getWidth() - fr.width(this.text);
            int n2 = y + this.getHeight();
            Objects.requireNonNull(fr);
            graphics.drawString(fr, this.text, n, n2 - 9, -1, false);
        }
    }
}

