/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.mojang.blaze3d.platform.InputConstants;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.heat.BlockHeatProperties;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class JEIBlockHeatPropertiesCategory
extends AbstractPNCCategory<HeatPropertiesRecipe> {
    private final IDrawable hotArea = JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 150, 0, 31, 18);
    private final IDrawable coldArea = JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 150, 18, 31, 18);
    private final IDrawable air = JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 150, 36, 16, 16);
    private static final Rect2i INPUT_AREA = new Rect2i(65, 44, 18, 18);
    private static final Rect2i COLD_AREA = new Rect2i(5, 44, 18, 18);
    private static final Rect2i HOT_AREA = new Rect2i(125, 44, 18, 18);
    private static final Rect2i[] OUTPUT_AREAS = new Rect2i[]{COLD_AREA, HOT_AREA};

    public JEIBlockHeatPropertiesCategory() {
        super(RecipeTypes.HEAT_PROPERTIES, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.title.heatProperties", new Object[0]), (IDrawable)JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 0, 0, 146, 73), (IDrawable)JEIBlockHeatPropertiesCategory.guiHelper().drawableBuilder(Textures.JEI_THERMOMETER, 0, 0, 16, 16).setTextureSize(16, 16).build());
    }

    public static List<HeatPropertiesRecipe> getAllRecipes() {
        return BlockHeatProperties.getInstance().getAllEntries((Level)Minecraft.getInstance().level).stream().filter(r -> r.getBlock() instanceof LiquidBlock || !new ItemStack((ItemLike)r.getBlock()).isEmpty()).sorted(Comparator.comparingInt(HeatPropertiesRecipe::getTemperature).thenComparing(o -> o.getInputDisplayName().getString())).toList();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HeatPropertiesRecipe recipe, IFocusGroup focuses) {
        this.setInputIngredient(builder, recipe);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        this.collectOutputs(recipe.getTransformCold().orElse(null), items, fluids);
        this.collectOutputs(recipe.getTransformHot().orElse(null), items, fluids);
        for (int idx = 0; idx < 2; ++idx) {
            if (!((FluidStack)fluids.get(idx)).isEmpty()) {
                builder.addSlot(RecipeIngredientRole.OUTPUT, OUTPUT_AREAS[idx].getX() + 2, OUTPUT_AREAS[idx].getY() - 1).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)((FluidStack)fluids.get(idx)));
                continue;
            }
            if (((ItemStack)items.get(idx)).isEmpty()) continue;
            builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack((ItemStack)items.get(idx));
        }
    }

    private void collectOutputs(BlockState state, List<ItemStack> items, List<FluidStack> fluids) {
        if (state != null) {
            Block block = state.getBlock();
            if (block instanceof LiquidBlock) {
                int level;
                LiquidBlock l = (LiquidBlock)block;
                int n = level = state.hasProperty((Property)LiquidBlock.LEVEL) ? (Integer)state.getValue((Property)LiquidBlock.LEVEL) : 15;
                if (level == 0) {
                    level = 15;
                }
                FluidStack stack = new FluidStack((Fluid)l.getFluid(), 1000 * level / 15);
                fluids.add(stack);
                items.add(new ItemStack((ItemLike)Blocks.BARRIER));
            } else {
                ItemStack stack = new ItemStack((ItemLike)state.getBlock());
                items.add(stack.isEmpty() ? new ItemStack((ItemLike)Blocks.BARRIER) : stack);
                fluids.add(FluidStack.EMPTY);
            }
        } else {
            items.add(new ItemStack((ItemLike)Blocks.BARRIER));
            fluids.add(FluidStack.EMPTY);
        }
    }

    private void setInputIngredient(IRecipeLayoutBuilder builder, HeatPropertiesRecipe recipe) {
        Block block = recipe.getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock l = (LiquidBlock)block;
            FluidStack stack = new FluidStack((Fluid)l.getFluid(), 1000);
            builder.addSlot(RecipeIngredientRole.INPUT, INPUT_AREA.getX() + 2, INPUT_AREA.getY() - 1).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)stack);
        } else {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(new ItemStack((ItemLike)block));
        }
    }

    public void draw(HeatPropertiesRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        Font fontRenderer = Minecraft.getInstance().font;
        Objects.requireNonNull(fontRenderer);
        int h = 9;
        MutableComponent desc = recipe.getDescriptionKey().isEmpty() ? Component.empty() : Component.literal((String)(" (" + I18n.get((String)recipe.getDescriptionKey(), (Object[])new Object[0]) + ")"));
        graphics.drawString(fontRenderer, (Component)recipe.getInputDisplayName().copy().append((Component)desc), 0, 0, 0x4040A0, false);
        MutableComponent temp = PneumaticCraftUtils.xlate("pneumaticcraft.waila.temperature", new Object[0]).append((Component)Component.literal((String)(recipe.getTemperature() - 273 + "\u00b0C")));
        graphics.drawString(fontRenderer, (Component)temp, 0, h * 2, 0x404040, false);
        recipe.getThermalResistance().ifPresent(resistance -> {
            String res = NumberFormat.getNumberInstance(Locale.getDefault()).format(resistance);
            graphics.drawString(fontRenderer, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.thermalResistance", new Object[0]).append(res), 0, h * 3, 0x404040, false);
        });
        boolean showCapacity = false;
        if (recipe.getTransformCold().isPresent()) {
            this.coldArea.draw(graphics, INPUT_AREA.getX() - this.coldArea.getWidth() - 5, 42);
            showCapacity = true;
        }
        if (recipe.getTransformHot().isPresent()) {
            this.hotArea.draw(graphics, HOT_AREA.getX() - this.hotArea.getWidth() - 5, 42);
            showCapacity = true;
        }
        this.renderBlock(recipe.getBlockState(), graphics, INPUT_AREA.getX() + 9, INPUT_AREA.getY() + 1);
        recipe.getTransformCold().ifPresent(state -> this.renderBlock((BlockState)state, graphics, COLD_AREA.getX() + 9, COLD_AREA.getY() + 1));
        recipe.getTransformHot().ifPresent(state -> this.renderBlock((BlockState)state, graphics, HOT_AREA.getX() + 9, HOT_AREA.getY() + 1));
        if (showCapacity) {
            recipe.getHeatCapacity().ifPresent(heatCapacity -> graphics.drawString(fontRenderer, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.heatCapacity", NumberFormat.getNumberInstance(Locale.getDefault()).format(heatCapacity)), 0, this.getBackground().getHeight() - h, 0x404040, false));
        }
    }

    public boolean handleInput(HeatPropertiesRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.getType() == InputConstants.Type.MOUSE) {
            int mouseButton = input.getValue();
            IFocus<?> focus = null;
            if (INPUT_AREA.contains((int)mouseX, (int)mouseY)) {
                focus = this.makeFocus(recipe.getBlock(), mouseButton == 0 ? RecipeIngredientRole.OUTPUT : RecipeIngredientRole.INPUT);
            } else if (recipe.getTransformCold().isPresent() && COLD_AREA.contains((int)mouseX, (int)mouseY)) {
                focus = this.makeFocus(recipe.getTransformCold().get().getBlock(), mouseButton == 0 ? RecipeIngredientRole.OUTPUT : RecipeIngredientRole.INPUT);
            } else if (recipe.getTransformHot().isPresent() && HOT_AREA.contains((int)mouseX, (int)mouseY)) {
                focus = this.makeFocus(recipe.getTransformHot().get().getBlock(), mouseButton == 0 ? RecipeIngredientRole.OUTPUT : RecipeIngredientRole.INPUT);
            }
            if (focus != null) {
                JEIPlugin.recipesGui.show(focus);
                return true;
            }
        }
        return false;
    }

    public List<Component> getTooltipStrings(HeatPropertiesRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> l = new ArrayList<Component>();
        if (INPUT_AREA.contains((int)mouseX, (int)mouseY)) {
            this.addTooltip(recipe.getBlock(), l);
        } else if (recipe.getTransformCold().isPresent() && COLD_AREA.contains((int)mouseX, (int)mouseY)) {
            this.addTooltip(recipe.getTransformCold().get().getBlock(), l);
        } else if (recipe.getTransformHot().isPresent() && HOT_AREA.contains((int)mouseX, (int)mouseY)) {
            this.addTooltip(recipe.getTransformHot().get().getBlock(), l);
        } else if (mouseY > 20.0 && mouseY < 30.0) {
            l.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.tooltip.thermalResistance", new Object[0]));
        } else if (recipe.getHeatCapacity().isPresent() && mouseY > 62.0) {
            l.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.tooltip.heatCapacity", new Object[0]));
        }
        return l;
    }

    private IFocus<?> makeFocus(Block block, RecipeIngredientRole mode) {
        return block == Blocks.AIR || block instanceof LiquidBlock ? null : JEIPlugin.jeiHelpers.getFocusFactory().createFocus(mode, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)block));
    }

    private void addTooltip(Block block, List<Component> list) {
        ItemStack stack = new ItemStack((ItemLike)block);
        list.add(stack.getHoverName());
        stack.getItem().appendHoverText(stack, ClientUtils.getClientLevel(), list, (TooltipFlag)(ClientUtils.hasShiftDown() ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        if (Minecraft.getInstance().options.advancedItemTooltips) {
            String regName = PneumaticCraftUtils.getRegistryName(stack.getItem()).map(ResourceLocation::toString).orElse("?");
            list.add((Component)Component.literal((String)regName).withStyle(ChatFormatting.DARK_GRAY));
        }
        list.add((Component)Component.literal((String)ModNameCache.getModName(stack.getItem())).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
    }

    private void renderBlock(BlockState state, GuiGraphics graphics, int x, int y) {
        if (state != null) {
            if (state.getBlock() == Blocks.AIR) {
                this.air.draw(graphics, x - 8, y - 2);
            } else {
                float rot = ClientUtils.getClientLevel().getGameTime() % 360L;
                GuiUtils.renderBlockInGui(graphics, state, x, y, 100.0f, rot, 15.0f);
            }
        }
    }
}

