/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.RefineryRecipe;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.common.block.RefineryControllerBlock;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.Helpers;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class JEIRefineryCategory
extends AbstractPNCCategory<RefineryRecipe> {
    private final ITickTimer tickTimer;
    private final Map<RefineryRecipe, WidgetTemperature> tempWidgets = new IdentityHashMap<RefineryRecipe, WidgetTemperature>();

    JEIRefineryCategory() {
        super(RecipeTypes.REFINERY, (Component)PneumaticCraftUtils.xlate(((RefineryControllerBlock)ModBlocks.REFINERY.get()).getDescriptionId(), new Object[0]), (IDrawable)JEIRefineryCategory.guiHelper().createDrawable(Textures.GUI_REFINERY, 6, 15, 166, 79), JEIRefineryCategory.guiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.REFINERY.get())));
        this.tickTimer = JEIPlugin.jeiHelpers.getGuiHelper().createTickTimer(60, 60, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RefineryRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 2, 10).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, recipe.getInput().getFluidStacks())).setFluidRenderer((long)recipe.getInput().getAmount(), true, 16, 64).setOverlay(Helpers.makeTankOverlay(64), 0, 0);
        int n = 1;
        for (FluidStack out : recipe.getOutputs()) {
            int h = out.getAmount() * 64 / recipe.getInput().getAmount();
            int yOff = 64 - h;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 69 + n * 20, 18 - n * 4 + yOff).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)out)).setFluidRenderer((long)out.getAmount(), true, 16, h).setOverlay(Helpers.makeTankOverlay(h), 0, 0);
            ++n;
        }
    }

    public void draw(RefineryRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        WidgetTemperature w = this.tempWidgets.computeIfAbsent(recipe, id -> WidgetTemperature.fromOperatingRange(26, 18, recipe.getOperatingTemp()));
        w.setTemperature(w.getTotalRange().getMin() + (w.getTotalRange().getMax() - w.getTotalRange().getMin()) * this.tickTimer.getValue() / this.tickTimer.getMaxValue());
        w.renderWidget(graphics, (int)mouseX, (int)mouseY, 0.0f);
    }

    public List<Component> getTooltipStrings(RefineryRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        WidgetTemperature w = this.tempWidgets.get(recipe);
        if (w != null && w.isMouseOver(mouseX, mouseY)) {
            return ImmutableList.of((Object)HeatUtil.formatHeatString(recipe.getOperatingTemp().asString(TemperatureRange.TemperatureScale.CELSIUS)));
        }
        return Collections.emptyList();
    }
}

