/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import com.google.gson.JsonElement;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import vazkii.patchouli.api.IVariableSerializer;

public class FluidStackVariableSerializer
implements IVariableSerializer<FluidStack> {
    public FluidStack fromJson(JsonElement json) {
        if (json.isJsonNull()) {
            return FluidStack.EMPTY;
        }
        if (json.isJsonPrimitive()) {
            return FluidStackVariableSerializer.fluidStackFromString(json.getAsString());
        }
        if (json.isJsonObject()) {
            return ModCraftingHelper.fluidStackFromJson(json.getAsJsonObject());
        }
        throw new IllegalArgumentException("Can't make an FluidStack from an array!");
    }

    public JsonElement toJson(FluidStack fluidStack) {
        return ModCraftingHelper.fluidStackToJson(fluidStack);
    }

    private static FluidStack fluidStackFromString(String s) {
        ResourceLocation fluidId;
        String id = s;
        int count = 1000;
        String[] split = s.split("#");
        if (split.length > 1) {
            id = split[0];
            count = Integer.parseInt(split[1]);
        }
        if (!BuiltInRegistries.FLUID.containsKey(fluidId = new ResourceLocation(id))) {
            throw new RuntimeException("Unknown fluid: " + id);
        }
        Fluid f = (Fluid)BuiltInRegistries.FLUID.get(fluidId);
        return new FluidStack(f, count);
    }
}

