/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.thirdparty.IDocsProvider;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.PatchouliAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;

public class Patchouli
implements IThirdParty,
IDocsProvider {
    static final ResourceLocation PNC_BOOK = PneumaticRegistry.RL("book");
    private static Screen prevGui;
    private static Screen bookGui;

    @Override
    public void clientPreInit(IEventBus modBus) {
        NeoForge.EVENT_BUS.register(ScreenListener.class);
        modBus.register(ConfigListener.class);
    }

    @Override
    public void clientInit() {
        PatchouliAccess.setup();
    }

    @Override
    public void showWidgetDocs(String path) {
        Screen prev = Minecraft.getInstance().screen;
        if (PatchouliAccess.openBookEntry(PneumaticRegistry.RL("programming/" + path))) {
            bookGui = Minecraft.getInstance().screen;
            prevGui = prev;
        }
    }

    @Override
    public boolean isInstalled() {
        return true;
    }

    @Override
    public ThirdPartyManager.ModType modType() {
        return ThirdPartyManager.ModType.DOCUMENTATION;
    }

    private static class ScreenListener {
        private static Runnable scheduledTask = null;

        private ScreenListener() {
        }

        @SubscribeEvent
        public static void onGuiClosing(ScreenEvent.Closing event) {
            if (prevGui != null && bookGui != null) {
                scheduledTask = () -> {
                    Minecraft.getInstance().setScreen(prevGui);
                    prevGui = null;
                };
                bookGui = null;
            }
        }

        @SubscribeEvent
        public static void clientTick(TickEvent.ClientTickEvent event) {
            if (scheduledTask != null) {
                scheduledTask.run();
                scheduledTask = null;
            }
        }
    }

    private static class ConfigListener {
        private ConfigListener() {
        }

        @SubscribeEvent
        public static void onConfigChange(ModConfigEvent.Reloading event) {
            if (event.getConfig().getModId().equals("pneumaticcraft")) {
                PatchouliAccess.setConfigFlags();
            }
        }
    }
}

