/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.theoneprobe;

import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.TOPInit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ElementPressure
implements IElement {
    private final float min;
    private final float pressure;
    private final float danger;
    private final float crit;
    private static final float SCALE = 0.7f;

    ElementPressure(BlockEntity te, IAirHandlerMachine airHandler) {
        this.min = te instanceof IMinWorkingPressure ? ((IMinWorkingPressure)te).getMinWorkingPressure() : 0.0f;
        this.pressure = airHandler.getPressure();
        this.danger = airHandler.getDangerPressure();
        this.crit = airHandler.getCriticalPressure();
    }

    ElementPressure(FriendlyByteBuf buf) {
        this.min = buf.readFloat();
        this.pressure = buf.readFloat();
        this.danger = buf.readFloat();
        this.crit = buf.readFloat();
    }

    public void render(GuiGraphics matrixStack, int x, int y) {
        matrixStack.pose().pushPose();
        matrixStack.pose().scale(0.7f, 0.7f, 0.7f);
        int x1 = (int)((float)(x + this.getWidth() / 2) / 0.7f);
        int y1 = (int)((float)(y + this.getHeight() / 2) / 0.7f);
        PressureGaugeRenderer2D.drawPressureGauge(matrixStack, Minecraft.getInstance().font, -1.0f, this.crit, this.danger, this.min, this.pressure, x1, y1, -4144960);
        matrixStack.pose().popPose();
    }

    public int getWidth() {
        return 40;
    }

    public int getHeight() {
        return 40;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.min);
        buf.writeFloat(this.pressure);
        buf.writeFloat(this.danger);
        buf.writeFloat(this.crit);
    }

    public ResourceLocation getID() {
        return TOPInit.ELEMENT_PRESSURE;
    }

    public static class Factory
    implements IElementFactory {
        public IElement createElement(FriendlyByteBuf friendlyByteBuf) {
            return new ElementPressure(friendlyByteBuf);
        }

        public ResourceLocation getId() {
            return TOPInit.ELEMENT_PRESSURE;
        }
    }
}

