/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.theoneprobe;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.PressureTubeBlock;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IInfoForwarder;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.TemperatureData;
import me.desht.pneumaticcraft.common.item.CamoApplicatorItem;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.ElementPressure;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TOPInfoProvider {
    private static final ChatFormatting COLOR = ChatFormatting.GRAY;

    static void handleBlock(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, IProbeHitData data) {
        BlockEntity te = world.getBlockEntity(data.getPos());
        if (te instanceof IInfoForwarder) {
            IInfoForwarder f = (IInfoForwarder)te;
            te = f.getInfoBlockEntity();
        }
        if (te == null) {
            return;
        }
        if (IOHelper.getCap(te, PNCCapabilities.AIR_HANDLER_MACHINE, null).isPresent()) {
            TOPInfoProvider.handlePneumatic(mode, probeInfo, te, data);
        }
        if (IOHelper.getCap(te, PNCCapabilities.HEAT_EXCHANGER_BLOCK, null).isPresent()) {
            TOPInfoProvider.handleHeat(mode, probeInfo, te);
        }
        if (((Boolean)ConfigHelper.client().general.topShowsFluids.get()).booleanValue()) {
            IOHelper.getCap(te, Capabilities.FluidHandler.BLOCK, data.getSideHit()).ifPresent(handler -> TOPInfoProvider.handleFluidTanks(mode, probeInfo, handler));
        }
        if (te instanceof IRedstoneControl) {
            TOPInfoProvider.handleRedstoneMode(mode, probeInfo, (IRedstoneControl)te);
        }
        if (te instanceof PressureTubeBlockEntity) {
            TOPInfoProvider.handlePressureTube(mode, probeInfo, (PressureTubeBlockEntity)te, data.getSideHit(), player);
        }
        if (te instanceof CamouflageableBlockEntity) {
            TOPInfoProvider.handleCamo(mode, probeInfo, ((CamouflageableBlockEntity)te).getCamouflage());
        }
    }

    static void handleSemiblock(Player player, ProbeMode mode, IProbeInfo probeInfo, ISemiBlock semiBlock) {
        IProbeInfo vert = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(semiBlock.getColor())));
        IProbeInfo horiz = vert.horizontal();
        NonNullList<ItemStack> drops = semiBlock.getDrops();
        if (!drops.isEmpty()) {
            ItemStack stack = (ItemStack)drops.get(0);
            horiz.item(stack);
            horiz.text(stack.getHoverName());
            semiBlock.addTooltip(arg_0 -> ((IProbeInfo)vert).text(arg_0), player, stack.getTag(), player.isShiftKeyDown());
        }
    }

    private static void handlePneumatic(ProbeMode mode, IProbeInfo probeInfo, BlockEntity pneumaticMachine, IProbeHitData data) {
        LinkedHashSet set = new LinkedHashSet();
        IOHelper.getCap(pneumaticMachine, PNCCapabilities.AIR_HANDLER_MACHINE, null).ifPresent(set::add);
        for (Direction dir : DirectionUtil.VALUES) {
            IOHelper.getCap(pneumaticMachine, PNCCapabilities.AIR_HANDLER_MACHINE, dir).ifPresent(set::add);
        }
        for (IAirHandlerMachine h : set) {
            TOPInfoProvider.addPressureInfo(mode, probeInfo, pneumaticMachine, h);
        }
    }

    private static void addPressureInfo(ProbeMode mode, IProbeInfo probeInfo, BlockEntity pneumaticMachine, IAirHandlerMachine airHandler) {
        String pressure = PneumaticCraftUtils.roundNumberTo(airHandler.getPressure(), 2);
        String dangerPressure = PneumaticCraftUtils.roundNumberTo(airHandler.getDangerPressure(), 2);
        probeInfo.text((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressureMax", pressure, dangerPressure).withStyle(COLOR));
        if (mode == ProbeMode.EXTENDED) {
            probeInfo.horizontal().element((IElement)new ElementPressure(pneumaticMachine, airHandler)).vertical().text((Component)Component.empty()).text((Component)Component.literal((String)(" \u2b05 " + pressure + " bar")));
        }
    }

    private static void handleHeat(ProbeMode mode, IProbeInfo probeInfo, BlockEntity heatExchanger) {
        TemperatureData tempData = new TemperatureData(heatExchanger);
        if (tempData.isMultisided()) {
            for (Direction face : DirectionUtil.VALUES) {
                if (!tempData.hasData(face)) continue;
                probeInfo.text(HeatUtil.formatHeatString(face, (int)tempData.getTemperature(face)));
            }
        } else if (tempData.hasData(null)) {
            probeInfo.text(HeatUtil.formatHeatString((int)tempData.getTemperature(null)));
        }
    }

    private static void handleRedstoneMode(ProbeMode mode, IProbeInfo probeInfo, IRedstoneControl<?> redstoneControl) {
        probeInfo.text(redstoneControl.getRedstoneController().getDescription());
    }

    private static void handlePressureTube(ProbeMode mode, IProbeInfo probeInfo, PressureTubeBlockEntity te, Direction face, Player player) {
        AbstractTubeModule module = PressureTubeBlock.getFocusedModule(te.nonNullLevel(), te.getBlockPos(), player);
        if (module != null) {
            ArrayList<Component> currenttip = new ArrayList<Component>();
            module.addInfo(currenttip);
            if (!currenttip.isEmpty()) {
                IProbeInfo vert = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(-12566273)));
                currenttip.forEach(arg_0 -> ((IProbeInfo)vert).text(arg_0));
            }
        }
    }

    static void handleFluidTanks(ProbeMode mode, IProbeInfo probeInfo, IFluidHandler handler) {
        if (mode == ProbeMode.EXTENDED) {
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack fluidStack = handler.getFluidInTank(i);
                MutableComponent fluidDesc = fluidStack.isEmpty() ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]) : Component.literal((String)(fluidStack.getAmount() + "mB ")).append((Component)PneumaticCraftUtils.xlate(fluidStack.getTranslationKey(), new Object[0]));
                probeInfo.text((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.tank", i + 1, fluidDesc.copy().withStyle(ChatFormatting.AQUA)));
            }
        }
    }

    private static void handleCamo(ProbeMode mode, IProbeInfo probeInfo, BlockState camo) {
        if (camo != null) {
            probeInfo.text((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.camo", CamoApplicatorItem.getCamoStateDisplayName(camo)));
        }
    }
}

